/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io;

import adams.core.io.AbstractFilenameGenerator;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;

public class ReportFieldFilenameGenerator
extends AbstractFilenameGenerator {
    private static final long serialVersionUID = -6774985545949876372L;
    protected Field m_Field;

    @Override
    public String globalInfo() {
        return "Obtains the filename from a field in the attached report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field());
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The report field to obtain the filename from.";
    }

    @Override
    public boolean canHandleNullObject() {
        return false;
    }

    @Override
    protected String doGenerate(Object obj) {
        String result = null;
        if (obj instanceof ReportHandler) {
            Object report = ((ReportHandler)obj).getReport();
            if (report != null && ((Report)report).hasValue(this.m_Field)) {
                result = "" + ((Report)report).getValue(this.m_Field);
            } else {
                this.getLogger().severe("No report or report field ('" + this.m_Field + "') present: " + report);
            }
        } else {
            this.getLogger().severe("Object is not a report handler: " + obj.getClass().getName());
        }
        return result;
    }
}

