/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionToString;
import java.io.File;

public class FileToString
extends AbstractConversionToString {
    private static final long serialVersionUID = 8828591710515484463L;
    protected boolean m_AbsolutePath;
    protected boolean m_UseForwardSlashes;

    @Override
    public String globalInfo() {
        return "Turns a File object into a String.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("absolute", "absolutePath", false);
        this.m_OptionManager.add("use-forward-slashes", "useForwardSlashes", false);
    }

    public void setAbsolutePath(boolean value) {
        this.m_AbsolutePath = value;
        this.reset();
    }

    public boolean getAbsolutePath() {
        return this.m_AbsolutePath;
    }

    public String absolutePathTipText() {
        return "If enabled, absolute paths are generated.";
    }

    public void setUseForwardSlashes(boolean value) {
        this.m_UseForwardSlashes = value;
        this.reset();
    }

    public boolean getUseForwardSlashes() {
        return this.m_UseForwardSlashes;
    }

    public String useForwardSlashesTipText() {
        return "If enabled, forward slashes are used in the output (but the '\\\\' prefix of UNC paths is not converted).";
    }

    @Override
    public Class accepts() {
        return File.class;
    }

    @Override
    protected Object doConvert() throws Exception {
        String result = this.m_AbsolutePath ? ((File)this.m_Input).getAbsolutePath() : ((File)this.m_Input).getPath();
        if (this.m_UseForwardSlashes) {
            result = result.startsWith("\\\\") ? "\\\\" + result.substring(2).replace("\\", "/") : result.replace("\\", "/");
        }
        return result;
    }
}

