/*
 * Decompiled with CFR 0.152.
 */
package adams.data.distribution;

import adams.data.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.RealDistribution;

public class Exponential
extends AbstractRealDistribution {
    private static final long serialVersionUID = -1708992443868275973L;
    protected double m_Mean;
    protected double m_InverseCumAccuracy;

    @Override
    public String globalInfo() {
        return "The Exponential distribution.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("mean", "mean", 0.0);
        this.m_OptionManager.add("inverse-cum-accuracy", "inverseCumAccuracy", 1.0E-9);
    }

    public void setMean(double value) {
        this.m_Mean = value;
        this.reset();
    }

    public double getMean() {
        return this.m_Mean;
    }

    public String meanTipText() {
        return "The mean.";
    }

    public void setInverseCumAccuracy(double value) {
        this.m_InverseCumAccuracy = value;
        this.reset();
    }

    public double getInverseCumAccuracy() {
        return this.m_InverseCumAccuracy;
    }

    public String inverseCumAccuracyTipText() {
        return "The inverse cumulative accuracy.";
    }

    @Override
    public RealDistribution getRealDistribution() {
        return new ExponentialDistribution(this.m_Mean, this.m_InverseCumAccuracy);
    }
}

