/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import JSci.maths.wavelet.cdf2_4.FastCDF2_4;
import JSci.maths.wavelet.daubechies2.FastDaubechies2;
import JSci.maths.wavelet.haar.FastHaar;
import JSci.maths.wavelet.symmlet8.FastSymmlet8;
import adams.core.EnumWithCustomDisplay;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.option.AbstractOption;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractFilter;
import adams.data.padding.PaddingHelper;
import adams.data.padding.PaddingType;
import java.util.List;

public abstract class AbstractFastWavelet<T extends DataContainer>
extends AbstractFilter<T>
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 8562484608944330752L;
    protected WaveletType m_WaveletType;
    protected PaddingType m_PaddingType;
    protected boolean m_InverseTransform;

    @Override
    public String globalInfo() {
        return "A filter that transforms the data with a wavelet.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Mark Hale");
        result.setValue(TechnicalInformation.Field.YEAR, "2009");
        result.setValue(TechnicalInformation.Field.TITLE, "JSci - A science API for Java");
        result.setValue(TechnicalInformation.Field.HTTP, "http://jsci.sourceforge.net/");
        return result;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("wavelet", "waveletType", WaveletType.HAAR);
        this.m_OptionManager.add("padding", "paddingType", PaddingType.ZERO);
        this.m_OptionManager.add("inverse", "inverseTransform", false);
    }

    public void setWaveletType(WaveletType value) {
        this.m_WaveletType = value;
        this.reset();
    }

    public WaveletType getWaveletType() {
        return this.m_WaveletType;
    }

    public String waveletTypeTipText() {
        return "The wavelet type to use for transforming the data.";
    }

    public void setPaddingType(PaddingType value) {
        this.m_PaddingType = value;
        this.reset();
    }

    public PaddingType getPaddingType() {
        return this.m_PaddingType;
    }

    public String paddingTypeTipText() {
        return "The padding type to use.";
    }

    public void setInverseTransform(boolean value) {
        this.m_InverseTransform = value;
        this.reset();
    }

    public boolean getInverseTransform() {
        return this.m_InverseTransform;
    }

    public String inverseTransformTipText() {
        return "If true, then the inverse transform is performed (wavelet -> normal space).";
    }

    protected abstract double getValue(DataPoint var1);

    protected abstract DataPoint newDataPoint(DataPoint var1, double var2);

    protected abstract DataPoint newDataPoint(List<DataPoint> var1, int var2, double var3);

    @Override
    protected T processData(T data) {
        FastHaar fwt;
        int i;
        DataContainer result = data.getHeader();
        List<DataPoint> points = data.toList();
        float[] values = new float[points.size()];
        for (i = 0; i < points.size(); ++i) {
            values[i] = (float)this.getValue((DataPoint)points.get(i));
        }
        if (!this.m_InverseTransform) {
            values = this.m_WaveletType == WaveletType.CDF2_4 ? PaddingHelper.pad(values, PaddingHelper.nextPowerOf2(values.length) + 1, this.m_PaddingType) : PaddingHelper.padPow2(values, this.m_PaddingType);
        }
        switch (this.m_WaveletType) {
            case HAAR: {
                fwt = new FastHaar();
                break;
            }
            case CDF2_4: {
                fwt = new FastCDF2_4();
                break;
            }
            case DAUBECHIES2: {
                fwt = new FastDaubechies2();
                break;
            }
            case SYMMLET8: {
                fwt = new FastSymmlet8();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled wavelet type: " + this.m_WaveletType);
            }
        }
        if (this.m_InverseTransform) {
            fwt.invTransform(values);
        } else {
            fwt.transform(values);
        }
        for (i = 0; i < values.length; ++i) {
            DataPoint newPoint = i < points.size() ? this.newDataPoint((DataPoint)points.get(i), values[i]) : this.newDataPoint(points, points.size() - i, values[i]);
            result.add(newPoint);
        }
        return (T)result;
    }

    public static enum WaveletType implements EnumWithCustomDisplay<WaveletType>
    {
        HAAR("Haar"),
        CDF2_4("CDF2 4"),
        DAUBECHIES2("Daubechies2"),
        SYMMLET8("Symmlet8");

        private String m_Display;
        private String m_Raw;

        private WaveletType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        @Override
        public String toDisplay() {
            return this.m_Display;
        }

        @Override
        public String toRaw() {
            return this.m_Raw;
        }

        @Override
        public WaveletType parse(String s) {
            return WaveletType.valueOf((AbstractOption)null, s);
        }

        public String toString() {
            return this.m_Display;
        }

        public static String toString(AbstractOption option, Object object) {
            return ((WaveletType)object).toRaw();
        }

        public static WaveletType valueOf(AbstractOption option, String str) {
            WaveletType result = null;
            try {
                result = WaveletType.valueOf(str);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result == null) {
                for (WaveletType f : WaveletType.values()) {
                    if (!f.toDisplay().equals(str)) continue;
                    result = f;
                    break;
                }
            }
            return result;
        }
    }
}

