/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Properties;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractSimpleReportReader<T extends Report>
extends AbstractReportReader<T> {
    private static final long serialVersionUID = -196559365684130179L;
    public static final String FILE_EXTENSION = "report";

    @Override
    public String globalInfo() {
        return "Reads a report file in properties file format.";
    }

    @Override
    public String getFormatDescription() {
        return "Properties file format";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    @Override
    protected int determineParentID(Report report) {
        return report.getDatabaseID();
    }

    @Override
    protected List<T> readData() {
        Properties props;
        ArrayList<Report> result = new ArrayList<Report>();
        try {
            props = new Properties();
            FileReader reader = new FileReader(this.m_Input.getAbsolutePath());
            props.load(reader);
            reader.close();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to read data from " + this.m_Input, e);
            props = new Properties();
        }
        result.add(Report.parseProperties(props));
        return result;
    }
}

