/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.Utils;
import adams.data.io.output.TextFileWriter;

public class TextFileWithLineNumbersWriter
extends TextFileWriter {
    private static final long serialVersionUID = 4958356636746933734L;
    protected String m_Separator;
    protected int m_Count;

    @Override
    public String globalInfo() {
        return "Writes the content to a text file, preceding each line with its line number.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("separator", "separator", "");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Count = 0;
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator between line number and line content.";
    }

    @Override
    protected String doWrite(String content, String name) {
        if (!this.m_Append) {
            this.m_Count = 0;
        }
        Object[] lines = content.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            ++this.m_Count;
            lines[i] = this.m_Count + this.m_Separator + (String)lines[i];
        }
        return super.doWrite(Utils.flatten(lines, "\n"), name);
    }
}

