/*
 * Decompiled with CFR 0.152.
 */
package adams.data.noise;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Performance;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.NotesHandler;
import adams.data.RegionRecorder;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDenoiser<T extends DataContainer>
extends AbstractOptionHandler
implements RegionRecorder<T>,
Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractDenoiser> {
    private static final long serialVersionUID = -1247356707842924341L;
    protected boolean m_RecordRegions;
    protected List<T> m_Regions;

    @Override
    protected void reset() {
        super.reset();
        this.m_Regions = new ArrayList<T>();
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regions", "recordRegions", false);
    }

    @Override
    public void setRecordRegions(boolean value) {
        this.m_RecordRegions = value;
        this.reset();
    }

    @Override
    public boolean getRecordRegions() {
        return this.m_RecordRegions;
    }

    @Override
    public String recordRegionsTipText() {
        return "If set to true, the noisy regions will be recorded as well.";
    }

    @Override
    public List<T> getRegions() {
        return new ArrayList<T>(this.m_Regions);
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract T processData(T var1);

    protected T postprocessData(T original, T denoised) {
        return denoised;
    }

    public T denoise(T data) {
        this.checkData(data);
        T result = this.processData(data);
        result = this.postprocessData(data, result);
        if (result instanceof NotesHandler) {
            ((NotesHandler)result).getNotes().addProcessInformation(this);
        }
        return result;
    }

    public String toStringRegions() {
        String result = "";
        if (this.m_RecordRegions) {
            result = result + "\n";
            result = result + "Regions: " + this.m_Regions.size();
            for (int i = 0; i < this.m_Regions.size(); ++i) {
                result = result + "\n";
                result = result + (i + 1) + ". " + ((DataContainer)this.m_Regions.get(i)).toTreeSet().first() + "-" + ((DataContainer)this.m_Regions.get(i)).toTreeSet().last() + " (= " + ((DataContainer)this.m_Regions.get(i)).size() + " points)";
            }
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractDenoiser shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractDenoiser shallowCopy(boolean expand) {
        return (AbstractDenoiser)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getDenoisers() {
        return ClassLister.getSingleton().getClassnames(AbstractDenoiser.class);
    }

    public static AbstractDenoiser forName(String classname, String[] options) {
        AbstractDenoiser result;
        try {
            result = (AbstractDenoiser)OptionUtils.forName(AbstractDenoiser.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractDenoiser forCommandLine(String cmdline) {
        return (AbstractDenoiser)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static DataContainer denoise(AbstractDenoiser denoiser, DataContainer data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.add(data);
        List<DataContainer> denoisedList = AbstractDenoiser.denoise(denoiser, dataList);
        DataContainer result = denoisedList.get(0);
        return result;
    }

    public static List<DataContainer> denoise(AbstractDenoiser denoiser, List<DataContainer> data) {
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        if (Performance.getMultiProcessingEnabled()) {
            int i;
            JobRunner runner = new JobRunner();
            JobList<DenoiserJob<DataContainer>> jobs = new JobList<DenoiserJob<DataContainer>>();
            for (i = 0; i < data.size(); ++i) {
                AbstractDenoiser threadDenoiser = denoiser.shallowCopy(true);
                jobs.add(new DenoiserJob<DataContainer>(threadDenoiser, data.get(i)));
            }
            runner.add(jobs);
            runner.start();
            runner.stop();
            for (i = 0; i < jobs.size(); ++i) {
                DenoiserJob job = (DenoiserJob)jobs.get(i);
                if (job.getDenoisedData() != null) {
                    result.add((DataContainer)job.getDenoisedData());
                    continue;
                }
                result.add(job.getData().getHeader());
            }
        } else {
            for (int i = 0; i < data.size(); ++i) {
                AbstractDenoiser threadDenoiser = denoiser.shallowCopy(true);
                result.add(threadDenoiser.denoise(data.get(i)));
            }
        }
        return result;
    }

    public static class DenoiserJob<T extends DataContainer>
    extends Job {
        private static final long serialVersionUID = -6605973712371846881L;
        protected AbstractDenoiser m_Denoiser;
        protected T m_Data;
        protected T m_DenoisedData;

        public DenoiserJob(AbstractDenoiser denoiser, T data) {
            this.m_Denoiser = denoiser;
            this.m_Data = data;
            this.m_DenoisedData = null;
        }

        public AbstractDenoiser getDenoiser() {
            return this.m_Denoiser;
        }

        public T getData() {
            return this.m_Data;
        }

        public T getDenoisedData() {
            return this.m_DenoisedData;
        }

        @Override
        protected String preProcessCheck() {
            if (this.m_Denoiser == null) {
                return "No denoiser set!";
            }
            if (this.m_Data == null) {
                return "No data set!";
            }
            return null;
        }

        @Override
        protected String getAdditionalErrorInformation() {
            if (this.m_Data instanceof NotesHandler) {
                return ((NotesHandler)this.m_Data).getNotes().toString();
            }
            return "";
        }

        @Override
        protected void process() throws Exception {
            this.m_DenoisedData = this.m_Denoiser.denoise(this.m_Data);
        }

        @Override
        protected String postProcessCheck() {
            if (this.m_DenoisedData == null) {
                return "Result from denoiser is null!";
            }
            return null;
        }

        @Override
        public void cleanUp() {
            super.cleanUp();
            this.m_Data = null;
            this.m_DenoisedData = null;
            this.m_Denoiser.destroy();
            this.m_Denoiser = null;
        }

        @Override
        public String toString() {
            String result = "data:" + this.m_Data.getID() + ", ";
            if (this.m_Data instanceof DatabaseIDHandler) {
                result = result + "db-id: " + ((DatabaseIDHandler)this.m_Data).getDatabaseID() + ", ";
            }
            result = result + "denoiser: " + OptionUtils.getCommandLine(this.m_Denoiser);
            return result;
        }
    }
}

