/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import java.util.ArrayList;
import java.util.List;

public class FieldRequired
extends AbstractOutlierDetector {
    private static final long serialVersionUID = -6838687006986727555L;
    protected Field m_Field;

    @Override
    public String globalInfo() {
        return "Checks whether the specified field is present in the report.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", new Field("blah", DataType.NUMERIC));
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to look for.";
    }

    protected List<String> processData(DataContainer data) {
        ArrayList<String> result = new ArrayList<String>();
        if (data instanceof ReportHandler) {
            ReportHandler handler = (ReportHandler)((Object)data);
            if (handler.getReport() != null) {
                Object t = ((Report)handler.getReport()).getValue(this.m_Field);
                if (t == null) {
                    result.add("Field '" + this.m_Field + "' not in report!");
                }
            } else {
                result.add("No report available!");
            }
        } else {
            result.add("Data container does not handle reports!");
        }
        return result;
    }
}

