/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.javadoc;

import adams.core.ClassLocator;
import adams.core.Utils;
import adams.doc.javadoc.Javadoc;
import adams.flow.container.AbstractContainer;
import adams.flow.core.Actor;
import adams.flow.core.ActorWithConditionalEquivalent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class FlowJavadoc
extends Javadoc {
    private static final long serialVersionUID = 3485326632649980955L;
    public static final String FLOW_STARTTAG = "<!-- flow-summary-start -->";
    public static final String FLOW_ENDTAG = "<!-- flow-summary-end -->";
    public static final String ACCEPTS_METHOD = "accepts";
    public static final String ACCEPTS_STARTTAG = "<!-- flow-accepts-start -->";
    public static final String ACCEPTS_ENDTAG = "<!-- flow-accepts-end -->";
    public static final String GENERATES_METHOD = "generates";
    public static final String GENERATES_STARTTAG = "<!-- flow-generates-start -->";
    public static final String GENERATES_ENDTAG = "<!-- flow-generates-end -->";

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StartTag = new String[3];
        this.m_EndTag = new String[3];
        this.m_IsBlock = new boolean[3];
        this.m_StartTag[0] = FLOW_STARTTAG;
        this.m_EndTag[0] = FLOW_ENDTAG;
        this.m_IsBlock[0] = true;
        this.m_StartTag[1] = ACCEPTS_STARTTAG;
        this.m_EndTag[1] = ACCEPTS_ENDTAG;
        this.m_IsBlock[1] = false;
        this.m_StartTag[2] = GENERATES_STARTTAG;
        this.m_EndTag[2] = GENERATES_ENDTAG;
        this.m_IsBlock[2] = false;
    }

    @Override
    protected String generateJavadoc(int index) throws Exception {
        int i;
        Class[] classes;
        Method generates;
        Method accepts;
        String result = "";
        if (!this.canInstantiateClass()) {
            return result;
        }
        if (!(this.getInstance() instanceof Actor)) {
            return result;
        }
        try {
            accepts = this.getInstance().getClass().getMethod(ACCEPTS_METHOD, null);
        }
        catch (Exception e) {
            accepts = null;
        }
        try {
            generates = this.getInstance().getClass().getMethod(GENERATES_METHOD, null);
        }
        catch (Exception e) {
            generates = null;
        }
        ArrayList<Class> containers = new ArrayList<Class>();
        if (index == 0 && (accepts != null || generates != null)) {
            Class condEquiv;
            StringBuilder info;
            if (accepts != null) {
                classes = (Class[])accepts.invoke(this.getInstance(), (Object[])null);
                result = result + "- accepts:\n";
                for (i = 0; i < classes.length; ++i) {
                    result = result + "\t" + Utils.classToString(classes[i]) + "\n";
                    if (!ClassLocator.isSubclass(AbstractContainer.class, classes[i])) continue;
                    containers.add(classes[i]);
                }
            }
            if (generates != null) {
                classes = (Class[])generates.invoke(this.getInstance(), (Object[])null);
                result = result + "- generates:\n";
                for (i = 0; i < classes.length; ++i) {
                    result = result + "\t" + Utils.classToString(classes[i]) + "\n";
                    if (!ClassLocator.isSubclass(AbstractContainer.class, classes[i])) continue;
                    containers.add(classes[i]);
                }
            }
            if (result.length() > 0) {
                result = this.toHTML("Input/output:\n" + result).trim().replaceAll("(\t)(.+)(<br\\/>)", "<pre>   $2</pre>");
                result = result + "\n<p/>\n";
            }
            if (containers.size() > 0) {
                info = new StringBuilder();
                info.append("Container information:");
                for (i = 0; i < containers.size(); ++i) {
                    info.append("\n- " + ((Class)containers.get(i)).getName() + ": ");
                    try {
                        AbstractContainer cont = (AbstractContainer)((Class)containers.get(i)).newInstance();
                        boolean first = true;
                        Iterator<String> enm = cont.names();
                        while (enm.hasNext()) {
                            if (!first) {
                                info.append(", ");
                            }
                            info.append(enm.next());
                            first = false;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                result = result + this.toHTML(info.toString());
                result = result + "\n<p/>\n";
            }
            if (this.getInstance() instanceof ActorWithConditionalEquivalent && (condEquiv = ((ActorWithConditionalEquivalent)this.getInstance()).getConditionalEquivalent()) != null) {
                info = new StringBuilder();
                info.append("Conditional equivalent:\n");
                info.append("\t" + condEquiv.getName());
                result = result + this.toHTML(info.toString());
                result = result + "\n<p/>\n";
            }
            if (this.getUseStars()) {
                result = this.indent(result, 1, "* ");
            }
        }
        if (index == 1 && accepts != null) {
            classes = (Class[])accepts.invoke(this.getInstance(), (Object[])null);
            result = "";
            for (i = 0; i < classes.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + Utils.classToString(classes[i]) + ".class";
            }
            result = this.toHTML(result);
            result = result.trim();
        }
        if (index == 2 && generates != null) {
            classes = (Class[])generates.invoke(this.getInstance(), (Object[])null);
            result = "";
            for (i = 0; i < classes.length; ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + Utils.classToString(classes[i]) + ".class";
            }
            result = this.toHTML(result);
            result = result.trim();
        }
        return result;
    }

    public static void main(String[] args) {
        FlowJavadoc.runJavadoc(FlowJavadoc.class, args);
    }
}

