/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public abstract class AbstractTag
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 6472066010192166545L;
    protected Hashtable<String, String> m_Attributes = new Hashtable();

    public AbstractTag(String tag) {
        super(tag);
    }

    public String getTag() {
        return (String)this.getUserObject();
    }

    public void setAttribute(String name, String value) {
        if (name.replaceAll("[a-zA-Z0-9]", "").length() > 0) {
            throw new IllegalArgumentException("Only attribute names consisting of alphanumeric characters are allowed: " + name);
        }
        this.m_Attributes.put(name, value);
    }

    public boolean hasAttribute(String name) {
        return this.m_Attributes.containsKey(name);
    }

    public String getAttribute(String name) {
        return this.m_Attributes.get(name);
    }

    public String removeAttribute(String name) {
        return this.m_Attributes.remove(name);
    }

    protected boolean isValidChild(AbstractTag child) {
        return true;
    }

    protected void preInsert(MutableTreeNode newChild, int childIndex) {
        if (!this.isValidChild((AbstractTag)newChild)) {
            throw new IllegalArgumentException("Invalid child tag: " + newChild);
        }
    }

    protected void doInsert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
    }

    protected void postInsert(MutableTreeNode newChild, int childIndex) {
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        this.preInsert(newChild, childIndex);
        this.doInsert(newChild, childIndex);
        this.postInsert(newChild, childIndex);
    }

    protected String getIndentation() {
        StringBuilder result = new StringBuilder();
        int level = this.getLevel();
        for (int i = 0; i < level; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    protected void appendStartTag(StringBuilder buffer) {
        buffer.append("<" + this.getTag());
        if (this.m_Attributes.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>(this.m_Attributes.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                buffer.append(" ");
                buffer.append(key);
                buffer.append("=\"");
                buffer.append(AbstractTag.toEntities(this.getAttribute(key)));
                buffer.append("\"");
            }
        }
        if (!this.hasContent()) {
            buffer.append("/");
        }
        buffer.append(">");
    }

    protected void appendEndTag(StringBuilder buffer) {
        buffer.append("</" + this.getTag() + ">");
        buffer.append("\n");
    }

    public abstract boolean hasContent();

    protected abstract void appendContent(StringBuilder var1);

    protected void doValidate() {
    }

    public void validate() {
        this.doValidate();
        for (int i = 0; i < this.getChildCount(); ++i) {
            AbstractTag child = (AbstractTag)this.getChildAt(i);
            child.validate();
        }
    }

    public void toXML(StringBuilder buffer) {
        String indent = this.getIndentation();
        buffer.append(indent);
        this.appendStartTag(buffer);
        if (this.hasContent()) {
            if (this.getChildCount() > 0) {
                buffer.append("\n");
                this.appendContent(buffer);
                buffer.append(indent);
            } else {
                this.appendContent(buffer);
            }
            this.appendEndTag(buffer);
        }
    }

    public static String toEntities(String s) {
        String result = s;
        result = result.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("@", "&#64;");
        result = result.replace("$", "&#36;");
        result = result.replace("\"", "&quot;");
        result = result.replace("/", "&#47;");
        result = result.replace("%", "&#37;");
        return result;
    }
}

