/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.HashSetInit;

public class HashSet
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -1349114354556041598L;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Evaluates to true if the payload of the current token is present in the specified hashset.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", new StorageName("hashset"));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName, "storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the hashset in the internal storage.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Object.class};
    }

    @Override
    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = false;
        if (!owner.getStorageHandler().getStorage().has(this.m_StorageName)) {
            this.getLogger().severe("Hashset '" + this.m_StorageName + "' not available! Not initialized with " + HashSetInit.class.getName() + "?");
        } else {
            java.util.HashSet hashset = (java.util.HashSet)owner.getStorageHandler().getStorage().get(this.m_StorageName);
            Object value = token.getPayload();
            result = hashset.contains(value);
        }
        return result;
    }
}

