/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.flow.control.Branch;
import adams.flow.core.ControlActor;
import adams.flow.core.SubFlowWrapUp;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractSink;

public class FreeMemory
extends AbstractSink
implements ControlActor {
    private static final long serialVersionUID = 2371563734394740356L;

    @Override
    public String globalInfo() {
        return "Attempts to free up memory of the sub-flow that it belongs to.\nThis actor is useful in case when sub-flows are only executed once, but still keep their data-structures and gobble up unnecessary memory. One scenario is having a " + Branch.class.getName() + " " + "actor with lots of sequences as branches, which only get executed once.\n" + "The parent must implement " + SubFlowWrapUp.class.getName() + " " + "in order for this to work.\n" + "CAUTION: Behind the scenes, all actors below this actor's parent " + "will call their wrapUp() methods to conserve space. Therefore, " + "use this actor with caution, as it will basically reset the actors.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            if (this.getParent() == null) {
                result = "No parent set!";
            } else if (!(this.getParent() instanceof SubFlowWrapUp)) {
                result = "Parent does not implement " + SubFlowWrapUp.class.getName() + "!";
            }
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Freeing up memory: " + this.getParent().getFullName());
        }
        ((SubFlowWrapUp)((Object)this.getParent())).wrapUpSubFlow();
        return null;
    }
}

