/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.condition.bool.Expression;
import adams.flow.control.TryCatch;
import adams.flow.core.ControlActor;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class RaiseError
extends AbstractTransformer
implements ControlActor,
BooleanConditionSupporter,
ClassCrossReference {
    private static final long serialVersionUID = -6615127883045169960L;
    protected BooleanCondition m_Condition;
    protected String m_ErrorMessage;

    @Override
    public String globalInfo() {
        return "Raises a " + Error.class.getName() + " if the condition evaluates to 'true', using the provided error message.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("condition", "condition", new Expression());
        this.m_OptionManager.add("error-msg", "errorMessage", "");
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{TryCatch.class};
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "condition", this.m_Condition, "condition: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "errorMessage", this.m_ErrorMessage.length() > 0 ? this.m_ErrorMessage : "-none-", ", error: ");
        return result;
    }

    @Override
    public void setCondition(BooleanCondition value) {
        this.m_Condition = value;
        this.reset();
    }

    @Override
    public BooleanCondition getCondition() {
        return this.m_Condition;
    }

    public String conditionTipText() {
        return "The boolean condition to evaluate.";
    }

    public void setErrorMessage(String value) {
        this.m_ErrorMessage = value;
        this.reset();
    }

    public String getErrorMessage() {
        return this.m_ErrorMessage;
    }

    public String errorMessageTipText() {
        return "The error message to raise.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        if (this.m_Condition.evaluate(this, this.m_InputToken)) {
            if (this.m_ErrorMessage.isEmpty()) {
                throw new Error();
            }
            throw new Error(this.m_ErrorMessage);
        }
        this.m_OutputToken = this.m_InputToken;
        this.m_InputToken = null;
        return null;
    }
}

