/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Utils;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.flow.control.AbstractDirector;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;

public class SequentialDirector
extends AbstractDirector {
    private static final long serialVersionUID = -1634725837304059804L;
    protected transient List<Token> m_FinalOutput;
    protected boolean m_Finished;
    protected boolean m_Executed;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FinalOutput = null;
    }

    protected boolean isFinalOutputRecorded() {
        return false;
    }

    protected List<Token> getFinalOutput() {
        if (this.m_FinalOutput == null) {
            this.m_FinalOutput = new ArrayList<Token>();
        }
        return this.m_FinalOutput;
    }

    protected String checkActorHasStopped(AbstractActor actor) {
        String result = null;
        if (actor.isStopped()) {
            Throwable th = new Throwable();
            th.fillInStackTrace();
            result = th.getStackTrace()[1].getMethodName() + ": Actor '" + actor.getFullName() + "' is stopped!";
        }
        return result;
    }

    protected String handleException(AbstractActor actor, String msg, Throwable t) {
        return Utils.handleException(actor, msg, t, this.m_ControlActor.getSilent());
    }

    protected String doInput(AbstractActor actor, Token input) {
        String result = null;
        result = this.checkActorHasStopped(actor);
        if (result != null) {
            return result;
        }
        try {
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().preInput(actor, input);
            }
            ((InputConsumer)((Object)actor)).input(input);
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().postInput(actor);
            }
        }
        catch (Throwable t) {
            result = this.handleException(actor, "Calling the 'input(Token)' method with token '" + input + "' generated error: ", t);
        }
        if (result != null && actor.hasErrorHandler()) {
            result = actor.getErrorHandler().handleError(actor, "input", result);
        }
        return result;
    }

    protected String doExecute(AbstractActor actor) {
        String result;
        String msg = this.checkActorHasStopped(actor);
        if (msg != null) {
            return msg;
        }
        try {
            if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
                this.getLogger().finest("Size before 'execute()': " + actor.sizeOf() + " [" + actor.getFullName() + "]");
            }
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().preExecute(actor);
            }
            result = actor.execute();
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().postExecute(actor);
            }
            if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
                this.getLogger().finest("Size after 'execute()': " + actor.sizeOf() + " [" + actor.getFullName() + "]");
            }
        }
        catch (Throwable t) {
            result = this.handleException(actor, "Calling the 'execute()' method generated error: ", t);
        }
        if (result != null && actor.hasErrorHandler()) {
            result = actor.getErrorHandler().handleError(actor, "execute", result);
        }
        return result;
    }

    protected boolean doHasOutput(AbstractActor actor) {
        boolean result;
        if (this.checkActorHasStopped(actor) != null) {
            return false;
        }
        String msgFull = null;
        try {
            result = ((OutputProducer)((Object)actor)).hasPendingOutput();
        }
        catch (Throwable t) {
            msgFull = this.handleException(actor, "Calling the 'hasPendingOutput()' method generated error: ", t);
            result = false;
        }
        if (msgFull != null && actor.hasErrorHandler()) {
            msgFull = actor.getErrorHandler().handleError(actor, "hasPendingOutput", msgFull);
        }
        return result;
    }

    protected Token doOutput(AbstractActor actor) {
        Token result;
        if (this.checkActorHasStopped(actor) != null) {
            return null;
        }
        String msgFull = null;
        try {
            if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
                this.getLogger().finest("Size before 'output()': " + actor.sizeOf() + " [" + actor.getFullName() + "]");
            }
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().preOutput(actor);
            }
            result = ((OutputProducer)((Object)actor)).output();
            if (actor.getFlowExecutionListeningSupporter().isFlowExecutionListeningEnabled()) {
                actor.getFlowExecutionListeningSupporter().getFlowExecutionListener().postOutput(actor, result);
            }
            if (LoggingHelper.isAtLeast(this.getLogger(), Level.FINEST)) {
                this.getLogger().finest("Size after 'output()': " + actor.sizeOf() + " [" + actor.getFullName() + "]");
            }
        }
        catch (Throwable t) {
            msgFull = this.handleException(actor, "Calling the 'output()' method generated error: ", t);
            result = null;
        }
        if (msgFull != null && actor.hasErrorHandler()) {
            msgFull = actor.getErrorHandler().handleError(actor, "output", msgFull);
        }
        return result;
    }

    protected AbstractActor doExecuteStandalones() {
        AbstractActor result = null;
        for (int i = 0; i < this.m_ControlActor.size(); ++i) {
            if (this.m_Paused) {
                this.pause();
            }
            if (this.isStopped() || this.isStopping() || this.isFlushing()) break;
            AbstractActor curr = this.m_ControlActor.get(i);
            if (curr.getSkip()) continue;
            if (!ActorUtils.isStandalone(curr)) {
                result = curr;
                break;
            }
            String actorResult = this.doExecute(curr);
            if (actorResult == null) {
                actorResult = this.checkActorHasStopped(curr);
            }
            if (actorResult == null || this.m_ControlActor.getSilent()) continue;
            this.getLogger().severe(curr.getFullName() + " generated following error output:\n" + actorResult);
            if (!curr.getStopFlowOnError()) continue;
            this.stopExecution();
            break;
        }
        return result;
    }

    protected String doExecuteActors(AbstractActor startActor) {
        boolean finished;
        String result = null;
        AbstractActor notFinishedActor = startActor;
        Stack<AbstractActor> pendingActors = new Stack<AbstractActor>();
        this.getFinalOutput().clear();
        do {
            int startIndex;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("--> iteration start");
            }
            if (this.isPaused()) {
                this.pause();
            }
            if (this.isStopped() || this.isStopping() || this.isFlushing()) break;
            if (pendingActors.size() > 0) {
                startIndex = this.m_ControlActor.indexOf(((AbstractActor)pendingActors.peek()).getName());
            } else {
                startIndex = this.m_ControlActor.indexOf(notFinishedActor.getName());
                notFinishedActor = null;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("Start index: " + startIndex);
            }
            AbstractActor curr = null;
            Token token = null;
            int lastActive = -1;
            if (this.m_ControlActor.active() > 0) {
                lastActive = this.m_ControlActor.lastActive().index();
            }
            for (int i = startIndex; i <= lastActive; ++i) {
                String actorResult;
                if (this.isPaused()) {
                    this.pause();
                }
                if (this.isStopped() || this.isStopping() || this.isFlushing()) break;
                curr = this.m_ControlActor.get(i);
                if (curr.getSkip()) continue;
                if (this.isLoggingEnabled()) {
                    this.getLogger().fine("Current actor: " + curr.getFullName());
                }
                if (token == null) {
                    if (curr instanceof OutputProducer && this.doHasOutput(curr)) {
                        pendingActors.pop();
                        this.getLogger().fine("Actor holds another output token: " + curr.getFullName());
                    } else {
                        actorResult = this.doExecute(curr);
                        if (actorResult != null && !this.m_ControlActor.getSilent()) {
                            this.getLogger().severe(curr.getFullName() + " generated following error output:\n" + actorResult);
                            if (curr.getStopFlowOnError()) break;
                        }
                        if (!curr.isFinished() && notFinishedActor == null) {
                            notFinishedActor = curr;
                        }
                        if (this.isLoggingEnabled()) {
                            this.getLogger().finer("Actor needed to be executed: " + curr.getFullName());
                        }
                    }
                    token = curr instanceof OutputProducer && this.doHasOutput(curr) ? this.doOutput(curr) : null;
                    if (this.getLoggingLevel() == LoggingLevel.FINEST) {
                        this.getLogger().finest("Token obtained from output: " + token);
                    } else {
                        this.getLogger().fine("Token obtained from output");
                    }
                    if (curr instanceof OutputProducer && this.doHasOutput(curr)) {
                        pendingActors.push(curr);
                        if (this.isLoggingEnabled()) {
                            this.getLogger().fine("Actor has more tokens on output: " + curr.getFullName());
                        }
                    }
                } else {
                    this.doInput(curr, token);
                    actorResult = this.doExecute(curr);
                    if (actorResult != null && !this.m_ControlActor.getSilent()) {
                        this.getLogger().severe(curr.getFullName() + " generated following error output:\n" + actorResult);
                        if (curr.getStopFlowOnError()) break;
                    }
                    if (!curr.isFinished() && notFinishedActor == null) {
                        notFinishedActor = curr;
                    }
                    if (this.getLoggingLevel() == LoggingLevel.FINEST) {
                        this.getLogger().finer("Actor processes token: " + curr.getFullName() + "/" + token);
                    } else {
                        this.getLogger().fine("Actor processes token: " + curr.getFullName());
                    }
                    if (curr instanceof OutputProducer) {
                        token = this.doHasOutput(curr) ? this.doOutput(curr) : null;
                        if (this.isLoggingEnabled()) {
                            this.getLogger().fine("Actor also produces tokens: " + curr.getFullName());
                        }
                        if (this.doHasOutput(curr)) {
                            if (this.isLoggingEnabled()) {
                                this.getLogger().fine("Actor also has more tokens on output: " + curr.getFullName());
                            }
                            pendingActors.push(curr);
                        }
                    } else {
                        token = null;
                    }
                }
                if (i == this.m_ControlActor.lastActive().index() && token != null && this.isFinalOutputRecorded()) {
                    this.getFinalOutput().add(token);
                }
                if (!(curr instanceof OutputProducer) || token != null) continue;
                if (!this.isLoggingEnabled()) break;
                this.getLogger().fine("No token generated, skipping rest of actors: " + curr.getFullName());
                break;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("notFinishedActor=" + notFinishedActor + ", pendingActors.size=" + pendingActors.size() + ", stopped=" + this.isStopped());
            }
            boolean bl = finished = notFinishedActor == null && pendingActors.size() == 0;
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info("---> execution finished: " + finished);
        } while (!finished && !this.isStopped() && !this.isStopping() && !this.isFlushing());
        return result;
    }

    @Override
    public String execute() {
        AbstractActor start;
        String result;
        block13: {
            result = null;
            start = null;
            this.m_Finished = false;
            this.m_Executed = true;
            this.m_Flushing = false;
            if (this.m_ControlActor.getActorHandlerInfo().canContainStandalones()) {
                try {
                    start = this.doExecuteStandalones();
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("doExecuteStandalones: " + (start == null ? "only standalones" : start.getFullName()));
                    }
                    break block13;
                }
                catch (Throwable t) {
                    result = this.handleException("Execution of standalones failed: ", t);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("doExecuteStandalones: " + result);
                    }
                    break block13;
                }
            }
            if (this.m_ControlActor.size() > 0) {
                start = this.m_ControlActor.get(0);
            }
        }
        if (!(result != null || this.isStopped() || this.isStopping() || this.isFlushing() || start == null)) {
            block14: {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("doExecuteActors: start");
                }
                try {
                    String msg = this.doExecuteActors(start);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("doExecuteActors: " + (msg == null ? "OK" : msg));
                    }
                    if (msg != null) {
                        result = "Execution of actors failed: " + msg;
                    }
                }
                catch (Throwable t) {
                    result = this.handleException("Execution of actors died: ", t);
                    if (!this.isLoggingEnabled()) break block14;
                    this.getLogger().info("doExecuteActors: " + result);
                }
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("doExecuteActors: end");
            }
        }
        this.getFinalOutput().clear();
        this.m_Finished = true;
        return result;
    }

    @Override
    public boolean isFinished() {
        return this.m_Executed && this.m_Finished || !this.m_Executed || this.m_Stopped;
    }

    @Override
    public void flushExecution() {
        super.flushExecution();
        this.m_FinalOutput.clear();
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        this.getFinalOutput().clear();
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_FinalOutput != null) {
            this.m_FinalOutput.clear();
        }
    }
}

