/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.Utils;
import adams.core.Variables;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;

public class FlowVariables
extends Variables {
    private static final long serialVersionUID = 1085438226194687237L;
    public static final String PREFIX_CALLABLEACTOR = "callable:";
    public static final String CALLABLEREF_NOT_FOUND = "CallableRefNotFound";
    public static final String PREFIX_STORAGE = "storage:";
    public static final String STORAGEREF_NOT_FOUND = "StorageRefNotFound";
    protected AbstractActor m_Flow = null;
    protected CallableActorHelper m_Helper = new CallableActorHelper();

    public void setFlow(AbstractActor value) {
        this.m_Flow = value;
    }

    public AbstractActor getFlow() {
        return this.m_Flow;
    }

    public boolean hasFlow() {
        return this.m_Flow != null;
    }

    @Override
    public void assign(Variables other) {
        super.assign(other);
        if (other instanceof FlowVariables) {
            this.setFlow(((FlowVariables)other).getFlow());
        }
    }

    @Override
    public boolean has(String name) {
        if (this.isObject(name)) {
            return true;
        }
        return super.has(name);
    }

    protected Object getCallableActorValue(String name, Object defValue) {
        String msg;
        Object result;
        block10: {
            result = defValue;
            AbstractActor callable = this.m_Helper.findCallableActor(this.m_Flow, new CallableActorReference(name));
            msg = null;
            if (callable != null) {
                if (ActorUtils.isSource(callable)) {
                    try {
                        msg = callable.execute();
                        if (msg != null) break block10;
                        OutputProducer prod = (OutputProducer)((Object)callable);
                        if (prod.hasPendingOutput()) {
                            Token output = prod.output();
                            if (output.getPayload() != null) {
                                result = output.getPayload();
                            } else {
                                msg = "Null token produced!";
                            }
                            break block10;
                        }
                        msg = "No output produced!";
                    }
                    catch (Exception e) {
                        msg = Utils.throwableToString(e);
                    }
                } else {
                    msg = "Not a source actor!";
                }
            } else {
                msg = "Not found - invalid reference?";
            }
        }
        if (msg != null) {
            System.err.println("Failed to obtain variable value from callable actor '" + name + "':");
            System.err.println(msg);
        }
        return result;
    }

    protected Object getStorageValue(String name, Object defValue) {
        Object result = defValue;
        StorageName sName = new StorageName(name);
        if (this.m_Flow.getStorageHandler().getStorage().has(sName)) {
            result = this.m_Flow.getStorageHandler().getStorage().get(sName);
        }
        return result;
    }

    @Override
    public String get(String name, String defValue) {
        Object obj;
        Object result = this.isObject(name) ? ((obj = this.getObject(name, defValue)) == null ? null : obj.toString()) : super.get(name, defValue);
        return result;
    }

    @Override
    public boolean isObject(String name) {
        boolean result = false;
        if (name == null) {
            return result;
        }
        if (this.hasFlow()) {
            result = (name = FlowVariables.extractName(name)).startsWith(PREFIX_CALLABLEACTOR) || name.startsWith(PREFIX_STORAGE);
        }
        return result;
    }

    @Override
    public Object getObject(String name, Object defValue) {
        Object result = (name = FlowVariables.extractName(name)).startsWith(PREFIX_CALLABLEACTOR) ? this.getCallableActorValue(name.substring(PREFIX_CALLABLEACTOR.length()), defValue) : (name.startsWith(PREFIX_STORAGE) ? this.getStorageValue(name.substring(PREFIX_STORAGE.length()), defValue) : defValue);
        return result;
    }

    protected String doExpandGlobalRefs(String s) {
        String name;
        String fullname;
        int pos;
        String result = s;
        String part = "@{callable:";
        if (result.indexOf(part) > -1) {
            pos = -1;
            do {
                pos = result.indexOf(part, pos + 1);
                fullname = result.substring(pos, result.indexOf("}", pos) + 1);
                name = FlowVariables.extractName(fullname).substring(PREFIX_CALLABLEACTOR.length());
            } while ((result = result.replace(fullname, "" + this.getCallableActorValue(name, CALLABLEREF_NOT_FOUND))).indexOf(part, pos) > -1);
        }
        if (result.indexOf(part = "@{storage:") > -1) {
            pos = -1;
            do {
                pos = result.indexOf(part, pos + 1);
                fullname = result.substring(pos, result.indexOf("}", pos) + 1);
                name = FlowVariables.extractName(fullname).substring(PREFIX_STORAGE.length());
            } while ((result = result.replace(fullname, "" + this.getStorageValue(name, STORAGEREF_NOT_FOUND))).indexOf(part, pos) > -1);
        }
        return result;
    }

    @Override
    protected String doExpand(String s) {
        String result = this.doExpandGlobalRefs(s);
        result = super.doExpand(result);
        return result;
    }

    @Override
    public void cleanUp() {
        this.m_Flow = null;
        super.cleanUp();
    }
}

