/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.CleanUpHandler;
import adams.core.Variables;
import adams.core.base.BaseString;
import adams.core.option.DebugNestedProducer;
import adams.flow.condition.bool.BooleanCondition;
import adams.flow.condition.bool.BooleanConditionSupporter;
import adams.flow.control.Breakpoint;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.execution.AbstractBreakpoint;
import adams.flow.execution.AbstractGraphicalFlowExecutionListener;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.flow.StoragePanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.ExpressionWatchPanel;
import adams.gui.tools.VariableManagementPanel;
import adams.gui.visualization.debug.InspectionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Debug
extends AbstractGraphicalFlowExecutionListener {
    private static final long serialVersionUID = -7287036923779341439L;
    protected int m_Width;
    protected int m_Height;
    protected AbstractBreakpoint[] m_Breakpoints;
    protected Breakpoint.View[] m_Views;
    protected BaseString[] m_Watches;
    protected ExpressionWatchPanel.ExpressionType[] m_WatchTypes;
    protected boolean m_Disabled;
    protected transient ControlPanel m_DebugPanel;
    protected boolean m_Blocked;

    @Override
    public String globalInfo() {
        return "Allows the user to define breakpoints that suspend the execution of the flow, allowing the inspection of the current flow state.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", this.getDefaultWidth(), -1, null);
        this.m_OptionManager.add("height", "height", this.getDefaultHeight(), -1, null);
        this.m_OptionManager.add("breakpoint", "breakpoints", new AbstractBreakpoint[0]);
        this.m_OptionManager.add("watch", "watches", new BaseString[0]);
        this.m_OptionManager.add("watch-type", "watchTypes", new ExpressionWatchPanel.ExpressionType[0]);
        this.m_OptionManager.add("view", "views", new Breakpoint.View[0]);
    }

    protected int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the dialog.";
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the dialog.";
    }

    public void setBreakpoints(AbstractBreakpoint[] value) {
        this.m_Breakpoints = value;
        this.reset();
    }

    public AbstractBreakpoint[] getBreakpoints() {
        return this.m_Breakpoints;
    }

    public String breakpointsTipText() {
        return "The breakpoints to use for suspending the flow execution.";
    }

    public void setWatches(BaseString[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (!Variables.isPlaceholder(value[i].getValue())) continue;
            value[i] = new BaseString("(" + value[i].getValue() + ")");
        }
        this.m_Watches = value;
        this.reset();
    }

    public BaseString[] getWatches() {
        return this.m_Watches;
    }

    public String watchesTipText() {
        return "The expression to display initially in the watch dialog; the type of the watch needs to be specified as well.";
    }

    public void setWatchTypes(ExpressionWatchPanel.ExpressionType[] value) {
        this.m_WatchTypes = value;
        this.reset();
    }

    public ExpressionWatchPanel.ExpressionType[] getWatchTypes() {
        return this.m_WatchTypes;
    }

    public String watchTypesTipText() {
        return "The types of the watch expressions; determines how the expressions get evaluated and displayed.";
    }

    public void setViews(Breakpoint.View[] value) {
        this.m_Views = value;
        this.reset();
    }

    public Breakpoint.View[] getViews() {
        return this.m_Views;
    }

    public String viewsTipText() {
        return "The views to display automatically when the breakpoint is reached.";
    }

    public void setDisabled(boolean value) {
        this.m_Disabled = value;
    }

    public boolean isDisabled() {
        return this.m_Disabled || this.m_DebugPanel == null;
    }

    @Override
    public String getListenerTitle() {
        return "Debug";
    }

    @Override
    public BasePanel newListenerPanel() {
        this.m_DebugPanel = new ControlPanel();
        this.m_DebugPanel.setOwner(this);
        for (int i = 0; i < this.m_Watches.length; ++i) {
            this.m_DebugPanel.addWatch(this.m_Watches[i].getValue(), this.m_WatchTypes[i]);
        }
        return this.m_DebugPanel;
    }

    @Override
    public Dimension getDefaultFrameSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    protected void updateGUI() {
        if (this.m_DebugPanel != null) {
            this.m_DebugPanel.closeParent();
        }
    }

    public boolean isBlocked() {
        return this.m_Blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockExecution() {
        this.m_Blocked = true;
        this.m_DebugPanel.update();
        while (this.m_Blocked && !this.m_DebugPanel.getCurrentActor().isStopped()) {
            try {
                Debug debug = this;
                synchronized (debug) {
                    this.wait(50L);
                }
            }
            catch (Exception exception) {
            }
        }
    }

    protected void unblockExecution() {
        this.m_Blocked = false;
    }

    protected void triggered(AbstractBreakpoint point, Actor actor, String hook) {
        if (this.isDisabled()) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info(point.getClass().getName() + "/" + hook + ": " + actor.getFullName());
        }
        this.m_DebugPanel.setCurrentHook(hook);
        this.m_DebugPanel.setCurrentActor(actor);
        this.m_DebugPanel.setCurrentToken(null);
        if (point instanceof BooleanConditionSupporter) {
            this.m_DebugPanel.setCurrentCondition(((BooleanConditionSupporter)((Object)point)).getCondition());
        } else {
            this.m_DebugPanel.setCurrentCondition(null);
        }
        this.m_DebugPanel.showFrame();
        this.m_DebugPanel.breakpointReached();
        this.blockExecution();
    }

    protected void triggered(AbstractBreakpoint point, Actor actor, String hook, Token token) {
        if (this.isDisabled()) {
            return;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info(point.getClass().getName() + "/" + hook + ": " + actor.getFullName() + "\n\t" + token);
        }
        this.m_DebugPanel.setCurrentHook(hook);
        this.m_DebugPanel.setCurrentActor(actor);
        this.m_DebugPanel.setCurrentToken(token);
        if (point instanceof BooleanConditionSupporter) {
            this.m_DebugPanel.setCurrentCondition(((BooleanConditionSupporter)((Object)point)).getCondition());
        } else {
            this.m_DebugPanel.setCurrentCondition(null);
        }
        this.m_DebugPanel.showFrame();
        this.m_DebugPanel.breakpointReached();
        this.blockExecution();
    }

    @Override
    public void preInput(Actor actor, Token token) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreInput(actor, token)) continue;
            this.triggered(point, actor, "preInput", token);
            break;
        }
    }

    @Override
    public void postInput(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostInput(actor)) continue;
            this.triggered(point, actor, "postInput");
            break;
        }
    }

    @Override
    public void preExecute(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreExecute(actor)) continue;
            this.triggered(point, actor, "preExecute");
            break;
        }
    }

    @Override
    public void postExecute(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostExecute(actor)) continue;
            this.triggered(point, actor, "postExecute");
            break;
        }
    }

    @Override
    public void preOutput(Actor actor) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPreOutput(actor)) continue;
            this.triggered(point, actor, "preOutput");
            break;
        }
    }

    @Override
    public void postOutput(Actor actor, Token token) {
        for (AbstractBreakpoint point : this.m_Breakpoints) {
            if (point.getDisabled() || !point.triggersPostOutput(actor, token)) continue;
            this.triggered(point, actor, "postOutput");
            break;
        }
    }

    public static class ControlPanel
    extends BasePanel
    implements CleanUpHandler {
        private static final long serialVersionUID = 1000900663466801934L;
        protected BaseTabbedPane m_TabbedPane;
        protected JToggleButton m_ButtonContinue;
        protected JToggleButton m_ButtonStop;
        protected JToggleButton m_ButtonDisableEnable;
        protected JToggleButton m_ButtonExpressions;
        protected JPanel m_PanelCondition;
        protected GenericObjectEditorPanel m_GOEPanelCondition;
        protected JToggleButton m_ButtonSource;
        protected JToggleButton m_ButtonVariables;
        protected JToggleButton m_ButtonStorage;
        protected JToggleButton m_ButtonInspectToken;
        protected JToggleButton m_ButtonInspectFlow;
        protected ExpressionWatchPanel m_PanelExpressions;
        protected VariableManagementPanel m_PanelVariables;
        protected InspectionPanel m_PanelInspectionToken;
        protected InspectionPanel m_PanelInspectionFlow;
        protected TextEditorPanel m_PanelSource;
        protected StoragePanel m_PanelStorage;
        protected JTextField m_TextActorPath;
        protected JToggleButton m_ButtonActorPath;
        protected JTextField m_TextHookMethod;
        protected transient Debug m_Owner;
        protected Token m_CurrentToken;
        protected Actor m_CurrentActor;
        protected String m_CurrentHook;
        protected BooleanCondition m_CurrentCondition;

        @Override
        protected void initGUI() {
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_TabbedPane = new BaseTabbedPane();
            this.add((Component)this.m_TabbedPane, "Center");
            JPanel panelAllButtons = new JPanel(new BorderLayout());
            this.add((Component)panelAllButtons, "North");
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder("Execution"));
            panelAllButtons.add((Component)panel, "North");
            JPanel panelButtons = new JPanel(new GridLayout(1, 3));
            panel.add((Component)panelButtons, "North");
            this.m_ButtonContinue = new JToggleButton("Continue", GUIHelper.getIcon("run.gif"));
            this.m_ButtonContinue.setMnemonic('C');
            this.m_ButtonContinue.setToolTipText("Continues with the flow execution");
            this.m_ButtonContinue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.continueFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonContinue);
            this.m_ButtonStop = new JToggleButton("Stop", GUIHelper.getIcon("stop.gif"));
            this.m_ButtonStop.setMnemonic('S');
            this.m_ButtonStop.setToolTipText("Stops the flow execution immediately");
            this.m_ButtonStop.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.stopFlowExecution();
                }
            });
            panelButtons.add(this.m_ButtonStop);
            this.m_ButtonDisableEnable = new JToggleButton("Disable", GUIHelper.getIcon("debug_off.png"));
            this.m_ButtonDisableEnable.setMnemonic('D');
            this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
            this.m_ButtonDisableEnable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.disableEnableBreakpoint();
                }
            });
            panelButtons.add(this.m_ButtonDisableEnable);
            this.m_PanelCondition = new JPanel(new FlowLayout(0));
            panel.add((Component)this.m_PanelCondition, "Center");
            this.m_GOEPanelCondition = new GenericObjectEditorPanel(BooleanCondition.class, new Breakpoint().getCondition(), false);
            this.m_GOEPanelCondition.setEditable(false);
            this.m_GOEPanelCondition.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    ControlPanel.this.update();
                }
            });
            this.m_PanelCondition.add(new JLabel("Condition"));
            this.m_PanelCondition.add(this.m_GOEPanelCondition);
            panelButtons = new JPanel(new GridLayout(2, 3));
            panelButtons.setBorder(BorderFactory.createTitledBorder("Runtime information"));
            panel = new JPanel(new BorderLayout());
            panel.add((Component)panelButtons, "North");
            panelAllButtons.add((Component)panel, "Center");
            this.m_ButtonExpressions = new JToggleButton("Expressions", GUIHelper.getIcon("glasses.gif"));
            this.m_ButtonExpressions.setMnemonic('x');
            this.m_ButtonExpressions.setToolTipText("Display dialog for watch expressions");
            this.m_ButtonExpressions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showWatchExpressions(ControlPanel.this.m_ButtonExpressions.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonExpressions);
            this.m_ButtonVariables = new JToggleButton("Variables", GUIHelper.getIcon("variable.gif"));
            this.m_ButtonVariables.setMnemonic('V');
            this.m_ButtonVariables.setToolTipText("Display dialog with currently active variables");
            this.m_ButtonVariables.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showVariables(ControlPanel.this.m_ButtonVariables.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonVariables);
            this.m_ButtonStorage = new JToggleButton("Storage", GUIHelper.getIcon("disk.png"));
            this.m_ButtonStorage.setMnemonic('t');
            this.m_ButtonStorage.setToolTipText("Display dialog with items currently stored in temporary storage");
            this.m_ButtonStorage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showStorage(ControlPanel.this.m_ButtonStorage.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonStorage);
            this.m_ButtonInspectToken = new JToggleButton("Inspect token", GUIHelper.getIcon("properties.gif"));
            this.m_ButtonInspectToken.setMnemonic('I');
            this.m_ButtonInspectToken.setToolTipText("Display dialog for inspecting the current token");
            this.m_ButtonInspectToken.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectToken(ControlPanel.this.m_ButtonInspectToken.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonInspectToken);
            this.m_ButtonInspectFlow = new JToggleButton("Inspect flow", GUIHelper.getIcon("flow.gif"));
            this.m_ButtonInspectFlow.setMnemonic('n');
            this.m_ButtonInspectFlow.setToolTipText("Display dialog for inspecting the current flow");
            this.m_ButtonInspectFlow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.inspectFlow(ControlPanel.this.m_ButtonInspectFlow.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonInspectFlow);
            this.m_ButtonSource = new JToggleButton("Source", GUIHelper.getIcon("source.png"));
            this.m_ButtonSource.setMnemonic('o');
            this.m_ButtonSource.setToolTipText("Display current flow state as source (nested format)");
            this.m_ButtonSource.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.showSource(ControlPanel.this.m_ButtonSource.isSelected());
                }
            });
            panelButtons.add(this.m_ButtonSource);
            panel = new JPanel(new FlowLayout(0));
            this.m_TextActorPath = new JTextField(30);
            this.m_TextActorPath.setEditable(false);
            this.m_ButtonActorPath = new JToggleButton(GUIHelper.getIcon("copy.gif"));
            this.m_ButtonActorPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(ControlPanel.this.m_TextActorPath.getText());
                }
            });
            this.m_TextHookMethod = new JTextField(15);
            this.m_TextHookMethod.setEditable(false);
            panel.add(new JLabel("Actor path"));
            panel.add(this.m_TextActorPath);
            panel.add(this.m_ButtonActorPath);
            panel.add(this.m_TextHookMethod);
            panelAllButtons.add((Component)panel, "South");
            this.m_PanelExpressions = new ExpressionWatchPanel();
        }

        @Override
        protected void finishInit() {
            super.finishInit();
            this.update();
        }

        protected Flow getFlow() {
            return (Flow)this.m_CurrentActor.getRoot();
        }

        public void update() {
            boolean actorPresent = this.getCurrentActor() != null;
            boolean stopped = actorPresent && this.getFlow().isStopped();
            boolean blocked = this.getOwner() != null && this.getOwner().isBlocked();
            this.m_ButtonContinue.setEnabled(actorPresent && !stopped && blocked);
            this.m_ButtonStop.setEnabled(actorPresent && !stopped);
            this.m_ButtonDisableEnable.setEnabled(actorPresent && !stopped);
            this.m_ButtonVariables.setEnabled(actorPresent);
            this.m_ButtonStorage.setEnabled(actorPresent);
            this.m_ButtonExpressions.setEnabled(actorPresent && !stopped && blocked);
            this.m_ButtonInspectFlow.setEnabled(actorPresent && !stopped && blocked);
            this.m_ButtonInspectToken.setEnabled(actorPresent && !stopped && blocked);
            this.m_ButtonSource.setEnabled(actorPresent && !stopped && blocked);
            this.m_PanelCondition.setEnabled(actorPresent && !stopped && blocked);
            this.m_ButtonActorPath.setEnabled(this.m_TextActorPath.getText().length() > 0);
        }

        public void queueUpdate() {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ControlPanel.this.update();
                }
            };
            SwingUtilities.invokeLater(run);
        }

        public void setOwner(Debug value) {
            this.m_Owner = value;
        }

        public Debug getOwner() {
            return this.m_Owner;
        }

        public void setCurrentToken(Token value) {
            this.m_CurrentToken = value;
        }

        public Token getCurrentToken() {
            return this.m_CurrentToken;
        }

        public void setCurrentActor(Actor value) {
            this.m_CurrentActor = value;
        }

        public Actor getCurrentActor() {
            return this.m_CurrentActor;
        }

        public void setCurrentHook(String value) {
            this.m_CurrentHook = value;
        }

        public String getCurrentHook() {
            return this.m_CurrentHook;
        }

        public void setCurrentCondition(BooleanCondition value) {
            this.m_CurrentCondition = value;
        }

        public BooleanCondition getCurrentCondition() {
            return this.m_CurrentCondition;
        }

        protected void continueFlowExecution() {
            this.getOwner().unblockExecution();
            this.queueUpdate();
        }

        protected void stopFlowExecution() {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(false);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
            this.getFlow().stopExecution("User stopped flow!");
            this.getOwner().unblockExecution();
        }

        protected void disableEnableBreakpoint() {
            this.getOwner().setDisabled(!this.getOwner().isDisabled());
            if (this.getOwner().isDisabled()) {
                this.m_ButtonDisableEnable.setText("Enable");
                this.m_ButtonDisableEnable.setMnemonic('E');
                this.m_ButtonDisableEnable.setToolTipText("Enable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug.png"));
            } else {
                this.m_ButtonDisableEnable.setText("Disable");
                this.m_ButtonDisableEnable.setMnemonic('D');
                this.m_ButtonDisableEnable.setToolTipText("Disable the breakpoint");
                this.m_ButtonDisableEnable.setIcon(GUIHelper.getIcon("debug_off.png"));
            }
            if (this.getOwner().isBlocked()) {
                this.continueFlowExecution();
            }
            this.queueUpdate();
        }

        protected void setPanelVisible(JPanel panel, String title, boolean visible) {
            int present = -1;
            for (int i = 0; i < this.m_TabbedPane.getTabCount(); ++i) {
                if (this.m_TabbedPane.getComponentAt(i) != panel) continue;
                present = i;
                break;
            }
            if (visible && present > -1 || !visible && present == -1) {
                return;
            }
            if (visible) {
                this.m_TabbedPane.addTab(title, panel);
                this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
            } else {
                this.m_TabbedPane.remove(present);
            }
        }

        protected void showWatchExpressions(boolean visible) {
            this.m_PanelExpressions.setVariables(this.getCurrentActor().getVariables());
            this.setPanelVisible(this.m_PanelExpressions, "Expressions", visible);
        }

        protected void showSource(boolean visible) {
            String content;
            if (this.m_PanelSource == null) {
                this.m_PanelSource = new TextEditorPanel();
                this.m_PanelSource.setTextFont(GUIHelper.getMonospacedFont());
                this.m_PanelSource.setEditable(false);
                this.m_PanelSource.setTabSize(2);
            }
            if (visible) {
                DebugNestedProducer producer = new DebugNestedProducer();
                producer.produce(this.getFlow());
                content = producer.toString();
                producer.cleanUp();
            } else {
                content = "";
            }
            this.m_PanelSource.setContent(content);
            this.setPanelVisible(this.m_PanelSource, "Source", visible);
        }

        protected void showVariables(boolean visible) {
            if (this.m_PanelVariables == null) {
                this.m_PanelVariables = new VariableManagementPanel();
            }
            this.m_PanelVariables.setVariables(this.getCurrentActor().getVariables());
            this.setPanelVisible(this.m_PanelVariables, "Variables", visible);
        }

        protected void inspectToken(boolean visible) {
            if (this.m_PanelInspectionToken == null) {
                this.m_PanelInspectionToken = new InspectionPanel();
            }
            this.m_PanelInspectionToken.setCurrent(this.m_CurrentToken);
            this.setPanelVisible(this.m_PanelInspectionToken, "Token", visible);
        }

        protected void inspectFlow(boolean visible) {
            if (this.m_PanelInspectionFlow == null) {
                this.m_PanelInspectionFlow = new InspectionPanel();
            }
            this.m_PanelInspectionFlow.setCurrent(this.getCurrentActor().getRoot());
            this.setPanelVisible(this.m_PanelInspectionFlow, "Flow", visible);
        }

        protected void showStorage(boolean visible) {
            if (this.m_PanelStorage == null) {
                this.m_PanelStorage = new StoragePanel();
            }
            this.setPanelVisible(this.m_PanelStorage, "Storage", visible);
            this.m_PanelStorage.setHandler(this.getCurrentActor().getStorageHandler());
        }

        protected void showFrame() {
            if (this.getParentDialog() != null) {
                this.getParentDialog().setVisible(true);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setVisible(true);
            }
        }

        public void breakpointReached() {
            this.m_TextActorPath.setText(this.getCurrentActor().getFullName());
            this.m_TextHookMethod.setText(this.getCurrentHook());
            if (this.getCurrentCondition() == null) {
                this.m_PanelCondition.setVisible(false);
            } else {
                this.m_GOEPanelCondition.setCurrent(this.getCurrentCondition().shallowCopy());
                this.m_PanelCondition.setVisible(true);
            }
            this.m_PanelExpressions.refreshAllExpressions();
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken.setCurrent(this.m_CurrentToken);
            }
            if (this.m_PanelInspectionFlow != null) {
                this.m_PanelInspectionFlow.setCurrent(this.getCurrentActor().getRoot());
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.setHandler(this.getCurrentActor().getStorageHandler());
            }
            this.update();
            block8: for (Breakpoint.View d : this.getOwner().getViews()) {
                switch (d) {
                    case SOURCE: {
                        this.m_ButtonSource.setSelected(true);
                        this.showSource(true);
                        continue block8;
                    }
                    case EXPRESSIONS: {
                        this.m_ButtonExpressions.setSelected(true);
                        this.showWatchExpressions(true);
                        continue block8;
                    }
                    case INSPECT_TOKEN: {
                        this.m_ButtonInspectToken.setSelected(true);
                        this.inspectToken(true);
                        continue block8;
                    }
                    case INSPECT_FLOW: {
                        this.m_ButtonInspectFlow.setSelected(true);
                        this.inspectFlow(true);
                        continue block8;
                    }
                    case STORAGE: {
                        this.m_ButtonStorage.setSelected(true);
                        this.showStorage(true);
                        continue block8;
                    }
                    case VARIABLES: {
                        this.m_ButtonVariables.setSelected(true);
                        this.showVariables(true);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled dialog type: " + (Object)((Object)d));
                    }
                }
            }
        }

        public void addWatch(String expr, ExpressionWatchPanel.ExpressionType type) {
            this.m_PanelExpressions.addExpression(expr, type);
        }

        @Override
        public void cleanUp() {
            if (this.m_PanelSource != null) {
                this.m_PanelSource = null;
            }
            if (this.m_PanelExpressions != null) {
                this.m_PanelExpressions = null;
            }
            if (this.m_PanelVariables != null) {
                this.m_PanelVariables = null;
            }
            if (this.m_PanelInspectionToken != null) {
                this.m_PanelInspectionToken = null;
            }
            if (this.m_PanelInspectionFlow != null) {
                this.m_PanelInspectionFlow = null;
            }
            if (this.m_PanelStorage != null) {
                this.m_PanelStorage.cleanUp();
                this.m_PanelStorage = null;
            }
        }
    }
}

