/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.Utils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionTraversalPath;
import adams.core.option.OptionTraverser;
import adams.flow.core.AbstractActor;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.gui.dialog.TextPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractListingProcessor
extends AbstractActorProcessor
implements GraphicalOutputProducingProcessor {
    private static final long serialVersionUID = 5159872442351040225L;
    protected List<String> m_List;

    protected abstract boolean isValid(Object var1);

    protected String objectToString(Object obj) {
        return obj.toString();
    }

    protected void process(Object obj) {
        if (this.isValid(obj)) {
            String item = this.objectToString(obj);
            if (item == null) {
                return;
            }
            if (this.isUniqueList() && this.m_List.contains(item)) {
                return;
            }
            this.m_List.add(item);
        }
    }

    protected abstract boolean isSortedList();

    protected abstract boolean isUniqueList();

    protected void initializeList() {
        this.m_List = new ArrayList<String>();
    }

    @Override
    protected void processActor(AbstractActor actor) {
        this.initializeList();
        actor.getOptionManager().traverse(new OptionTraverser(){

            @Override
            public void handleClassOption(ClassOption option, OptionTraversalPath path) {
                Object current = option.getCurrentValue();
                if (option.isMultiple()) {
                    for (int i = 0; i < Array.getLength(current); ++i) {
                        AbstractListingProcessor.this.process(Array.get(current, i));
                    }
                } else {
                    AbstractListingProcessor.this.process(current);
                }
            }

            @Override
            public void handleBooleanOption(BooleanOption option, OptionTraversalPath path) {
            }

            @Override
            public void handleArgumentOption(AbstractArgumentOption option, OptionTraversalPath path) {
            }

            @Override
            public boolean canHandle(AbstractOption option) {
                return true;
            }

            @Override
            public boolean canRecurse(Class cls) {
                return true;
            }

            @Override
            public boolean canRecurse(Object obj) {
                return this.canRecurse(obj.getClass());
            }
        });
        this.finalizeList();
    }

    protected void finalizeList() {
        if (this.isSortedList()) {
            Collections.sort(this.m_List);
        }
    }

    @Override
    public boolean hasGraphicalOutput() {
        return this.m_List.size() > 0;
    }

    protected abstract String getHeader();

    protected Dimension getDefaultSize() {
        return new Dimension(400, 300);
    }

    @Override
    public Component getGraphicalOutput() {
        TextPanel result = new TextPanel();
        result.setPreferredSize(this.getDefaultSize());
        result.setEditable(false);
        result.setContent(Utils.flatten(this.m_List, "\n"));
        result.setInfoText(this.getHeader());
        return result;
    }
}

