/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseCharset;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 3613018887562327088L;
    protected BaseCharset m_Encoding;

    @Override
    public String globalInfo() {
        return "Writes a " + Document.class.getName() + " to an XML file.\n" + "In case of " + Node.class.getName() + " objects, the owning " + "document is written to disk.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", new BaseCharset());
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setEncoding(BaseCharset value) {
        this.m_Encoding = value;
        this.reset();
    }

    public BaseCharset getEncoding() {
        return this.m_Encoding;
    }

    public String encodingTipText() {
        return "The type of encoding to use when writing to the file.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "encoding", this.m_Encoding, ", encoding: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Document.class, Node.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            Document doc = this.m_InputToken.getPayload() instanceof Document ? (Document)this.m_InputToken.getPayload() : ((Node)this.m_InputToken.getPayload()).getOwnerDocument();
            DOMSource dsource = new DOMSource(doc);
            PrintStream pstream = new PrintStream((OutputStream)new FileOutputStream(this.m_OutputFile.getAbsolutePath()), true, this.m_Encoding.getValue());
            StreamResult sresult = new StreamResult(pstream);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(dsource, sresult);
        }
        catch (Exception e) {
            result = this.handleException("Failed to write DOM document to " + this.m_OutputFile, e);
        }
        return result;
    }
}

