/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.canvas;

import adams.flow.sink.canvas.AbstractDataPoolPostProcessor;
import adams.flow.sink.canvas.DataPool;
import adams.flow.sink.canvas.DataPoolPaintlet;
import adams.flow.sink.canvas.PassThrough;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;

public class DataPoolPanel
extends PaintablePanel {
    private static final long serialVersionUID = 1131414446883475974L;
    protected DataPool m_Pool;
    protected AbstractDataPoolPostProcessor m_PostProcessor;
    protected PlotPanel m_Plot;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PostProcessor = new PassThrough();
        this.m_Pool = new DataPool();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new PlotPanel();
        this.m_Plot.addPaintListener(this);
        this.add((Component)this.m_Plot, "Center");
    }

    public DataPool getPool() {
        return this.m_Pool;
    }

    @Override
    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    @Override
    protected void prepareUpdate() {
        for (Paintlet paintlet : this.m_Paintlets) {
            if (!(paintlet instanceof DataPoolPaintlet)) continue;
            ((DataPoolPaintlet)paintlet).prepareUpdate();
        }
    }

    @Override
    protected void postUpdate() {
        if (this.m_PostProcessor != null) {
            this.m_PostProcessor.postProcess(this.getPool());
        }
    }

    @Override
    protected boolean canPaint(Graphics g) {
        return this.m_Paintlets.size() > 0;
    }

    public void setPostProcessor(AbstractDataPoolPostProcessor value) {
        this.m_PostProcessor = value;
        this.update();
    }

    public AbstractDataPoolPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public void addData(Object obj) {
        this.addData(obj, true);
    }

    public void addData(Object obj, boolean redraw) {
        this.getPool().add(obj);
        if (redraw) {
            this.update();
        }
    }

    public void clear() {
        this.getPool().clear();
        this.update();
    }
}

