/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.flow.sink.sequenceplotter.AbstractErrorPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import java.awt.Color;
import java.awt.Graphics;

public class SimpleErrorPaintlet
extends AbstractErrorPaintlet {
    private static final long serialVersionUID = -713940308371660030L;
    protected PlotType m_PlotType;
    protected int m_MarkerLength;

    @Override
    public String globalInfo() {
        return "Paints simple error bars for X and Y (if available).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-type", "plotType", (Object)PlotType.BAR);
        this.m_OptionManager.add("marker-length", "markerLength", 5, 1, null);
    }

    public void setPlotType(PlotType value) {
        this.m_PlotType = value;
        this.reset();
    }

    public PlotType getPlotType() {
        return this.m_PlotType;
    }

    public String plotTypeTipText() {
        return "The type of plot to use for displaying the errors; " + (Object)((Object)PlotType.BOX) + " requires X and Y errors to be present, " + "otherwise it falls back to " + (Object)((Object)PlotType.LINE) + ".";
    }

    public void setMarkerLength(int value) {
        this.m_MarkerLength = value;
        this.reset();
    }

    public int getMarkerLength() {
        return this.m_MarkerLength;
    }

    public String markerLengthTipText() {
        return "The length in pixels for the markers in case of " + (Object)((Object)PlotType.BAR) + ".";
    }

    protected void drawErrorLine(Graphics g, AxisPanel axisX, AxisPanel axisY, SequencePlotPoint point) {
        double to;
        double from;
        Double[] error;
        if (point.hasErrorX()) {
            error = point.getErrorX();
            if (error.length == 1) {
                from = point.getX() - error[0];
                to = point.getX() + error[0];
            } else {
                from = error[0];
                to = error[1];
            }
            g.drawLine(axisX.valueToPos(from), axisY.valueToPos(point.getY()), axisX.valueToPos(to), axisY.valueToPos(point.getY()));
        }
        if (point.hasErrorY()) {
            error = point.getErrorY();
            if (error.length == 1) {
                from = point.getY() - error[0];
                to = point.getY() + error[0];
            } else {
                from = error[0];
                to = error[1];
            }
            g.drawLine(axisX.valueToPos(point.getX()), axisY.valueToPos(from), axisX.valueToPos(point.getX()), axisY.valueToPos(to));
        }
    }

    protected void drawErrorBar(Graphics g, AxisPanel axisX, AxisPanel axisY, SequencePlotPoint point) {
        double to;
        double from;
        Double[] error;
        int length = (int)((double)((float)this.m_MarkerLength - this.m_StrokeThickness) / 2.0);
        if (point.hasErrorX()) {
            error = point.getErrorX();
            if (error.length == 1) {
                from = point.getX() - error[0];
                to = point.getX() + error[0];
            } else {
                from = error[0];
                to = error[1];
            }
            g.drawLine(axisX.valueToPos(from), axisY.valueToPos(point.getY()), axisX.valueToPos(to), axisY.valueToPos(point.getY()));
            g.drawLine(axisX.valueToPos(from), axisY.valueToPos(point.getY()) - length, axisX.valueToPos(from), axisY.valueToPos(point.getY()) + length);
            g.drawLine(axisX.valueToPos(to), axisY.valueToPos(point.getY()) - length, axisX.valueToPos(to), axisY.valueToPos(point.getY()) + length);
        }
        if (point.hasErrorY()) {
            error = point.getErrorY();
            if (error.length == 1) {
                from = point.getY() - error[0];
                to = point.getY() + error[0];
            } else {
                from = error[0];
                to = error[1];
            }
            g.drawLine(axisX.valueToPos(point.getX()), axisY.valueToPos(from), axisX.valueToPos(point.getX()), axisY.valueToPos(to));
            g.drawLine(axisX.valueToPos(point.getX()) - length, axisY.valueToPos(from), axisX.valueToPos(point.getX()) + length, axisY.valueToPos(from));
            g.drawLine(axisX.valueToPos(point.getX()) - length, axisY.valueToPos(to), axisX.valueToPos(point.getX()) + length, axisY.valueToPos(to));
        }
    }

    protected void drawErrorBox(Graphics g, AxisPanel axisX, AxisPanel axisY, SequencePlotPoint point) {
        double toY;
        double fromY;
        double toX;
        double fromX;
        Double[] error = point.getErrorX();
        if (error.length == 1) {
            fromX = point.getX() - error[0];
            toX = point.getX() + error[0];
        } else {
            fromX = error[0];
            toX = error[1];
        }
        error = point.getErrorY();
        if (error.length == 1) {
            fromY = point.getY() - error[0];
            toY = point.getY() + error[0];
        } else {
            fromY = error[0];
            toY = error[1];
        }
        g.drawRect(axisX.valueToPos(fromX), axisY.valueToPos(toY), axisX.valueToPos(toX) - axisX.valueToPos(fromX) + 1, axisY.valueToPos(fromY) - axisY.valueToPos(toY) + 1);
    }

    @Override
    protected void drawData(Graphics g, SequencePlotSequence data, Color color) {
        g.setColor(color);
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        block5: for (Object o : data.toList()) {
            if (!(o instanceof SequencePlotPoint)) continue;
            SequencePlotPoint point = (SequencePlotPoint)o;
            PlotType type = this.m_PlotType;
            if (!(type != PlotType.BOX || point.hasErrorX() && point.hasErrorY())) {
                type = PlotType.LINE;
            }
            switch (type) {
                case LINE: {
                    this.drawErrorLine(g, axisX, axisY, point);
                    continue block5;
                }
                case BAR: {
                    this.drawErrorBar(g, axisX, axisY, point);
                    continue block5;
                }
                case BOX: {
                    this.drawErrorBox(g, axisX, axisY, point);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unhandled error bar type: " + (Object)((Object)type));
        }
    }

    public static enum PlotType {
        LINE,
        BAR,
        BOX;

    }
}

