/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class CombineStorage
extends AbstractSimpleSource {
    private static final long serialVersionUID = -7838881435448178095L;
    protected BaseText m_Expression;

    @Override
    public String globalInfo() {
        return "Outputs the expanded string generated from the specified combination expression (variables and storage placeholders). In case of storage placeholders the string representation of the storage item is used.\nThe expression string consists of arbitrary strings and the following special placeholders:\n- variables: @{...}\n- storage placeholders: %{...}\n";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new BaseText(""));
    }

    public void setExpression(BaseText value) {
        this.m_Expression = value;
        this.reset();
    }

    public BaseText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to use for combining the variables and storage placeholders.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression.stringValue());
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        String expanded = this.getVariables().expand(this.m_Expression.getValue());
        expanded = this.getStorageHandler().getStorage().expand(expanded);
        if (this.isLoggingEnabled()) {
            this.getLogger().info(this.m_Expression.getValue() + " -> " + expanded);
        }
        this.m_OutputToken = new Token(expanded);
        return result;
    }
}

