/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.VariableName;
import adams.data.conversion.ReplaceFileExtension;
import adams.flow.control.Tee;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;
import adams.flow.transformer.BaseName;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SetVariable;

public class StoreFilenameInVariable
extends AbstractActorTemplate {
    private static final long serialVersionUID = 2083397920389605009L;
    protected VariableName m_VariableName;
    protected boolean m_StripPath;
    protected boolean m_StripExtension;

    @Override
    public String globalInfo() {
        return "Creates a sub-flow that stores the filename passing through in a user-specified variable.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variable", "variableName", new VariableName());
        this.m_OptionManager.add("strip-path", "stripPath", false);
        this.m_OptionManager.add("strip-extension", "stripExtension", false);
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to store the report value in.";
    }

    public void setStripPath(boolean value) {
        this.m_StripPath = value;
        this.reset();
    }

    public boolean getStripPath() {
        return this.m_StripPath;
    }

    public String stripPathTipText() {
        return "If enabled, the path gets stripped from the filename.";
    }

    public void setStripExtension(boolean value) {
        this.m_StripExtension = value;
        this.reset();
    }

    public boolean getStripExtension() {
        return this.m_StripExtension;
    }

    public String stripExtensionTipText() {
        return "If enabled, the extension gets stripped from the filename.";
    }

    @Override
    protected AbstractActor doGenerate() {
        Tee result = new Tee();
        result.setName("Store filename in " + this.m_VariableName.paddedValue());
        if (this.m_StripPath) {
            BaseName base = new BaseName();
            base.setRemoveExtension(this.m_StripExtension);
            result.add(base);
        } else if (this.m_StripExtension) {
            ReplaceFileExtension ext = new ReplaceFileExtension();
            ext.setExtension("");
            Convert convert = new Convert();
            convert.setConversion(ext);
            result.add(convert);
        }
        SetVariable setvar = new SetVariable();
        setvar.setVariableName(this.m_VariableName);
        result.add(setvar);
        return result;
    }
}

