/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.container.DataContainer;
import adams.db.DataProvider;
import adams.db.FilteredDataProvider;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractDbTransformer;
import adams.flow.transformer.datacontainer.AbstractDataContainerPostProcessor;
import adams.flow.transformer.datacontainer.NoPostProcessing;

public abstract class AbstractDataContainerDbReader<T extends DataContainer>
extends AbstractDbTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -4736058667429890220L;
    protected boolean m_Raw;
    protected AbstractDataContainerPostProcessor m_PostProcessor;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("raw", "raw", false);
        this.m_OptionManager.add("post-processor", "postProcessor", new NoPostProcessing());
    }

    public void setRaw(boolean value) {
        this.m_Raw = value;
        this.reset();
    }

    public boolean getRaw() {
        return this.m_Raw;
    }

    public String rawTipText() {
        return "If set to true, then the raw data is returned instead of being filtered through the global data container filter.";
    }

    public void setPostProcessor(AbstractDataContainerPostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractDataContainerPostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to apply to the data.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Integer.class};
    }

    @Override
    public abstract Class[] generates();

    protected abstract DataProvider<T> getDataProvider();

    @Override
    protected String queryDatabase() {
        String result = null;
        DataProvider<T> provider = this.getDataProvider();
        Integer id = (Integer)this.m_InputToken.getPayload();
        T cont = this.m_Raw ? ((FilteredDataProvider)provider).loadRaw(id) : provider.load(id);
        if (cont == null) {
            result = "No container loaded for ID: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(this.m_PostProcessor.postProcess(cont));
        }
        if (this.m_OutputToken != null) {
            this.updateProvenance(this.m_OutputToken);
        }
        return result;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

