/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.container.DataContainer;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.io.input.IncrementalDataContainerReader;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class AbstractDataContainerFileReader<T extends DataContainer>
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 2136481673137019370L;
    public static final String BACKUP_CONTAINERS = "containers";
    protected AbstractDataContainerReader<T> m_Reader;
    protected List m_Containers;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
    }

    protected abstract AbstractDataContainerReader getDefaultReader();

    public void setReader(AbstractDataContainerReader value) {
        this.m_Reader = value;
        this.reset();
    }

    public AbstractDataContainerReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader to use for importing the data.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "reader", this.m_Reader);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public abstract Class[] generates();

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CONTAINERS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_CONTAINERS, this.m_Containers);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CONTAINERS)) {
            this.m_Containers = (List)state.get(BACKUP_CONTAINERS);
            state.remove(BACKUP_CONTAINERS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Containers = new ArrayList();
    }

    @Override
    protected String doExecute() {
        String result = null;
        PlaceholderFile file = new PlaceholderFile((String)this.m_InputToken.getPayload());
        this.m_Reader.setInput(file);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Attempting to load '" + file + "'");
        }
        try {
            this.m_Containers = this.m_Reader.read();
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.m_Containers.size() + " containers read");
            }
            if (!(this.m_Reader instanceof IncrementalDataContainerReader)) {
                this.m_Reader.cleanUp();
            }
        }
        catch (Exception e) {
            result = this.handleException("Error reading '" + file + "': ", e);
            this.m_Containers.clear();
            return result;
        }
        return result;
    }

    @Override
    public Token output() {
        if (this.m_Reader instanceof IncrementalDataContainerReader && this.m_Containers.size() == 0) {
            this.m_Containers = this.m_Reader.read();
        }
        Token result = new Token(this.m_Containers.get(0));
        this.m_Containers.remove(0);
        this.updateProvenance(result);
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_Reader instanceof IncrementalDataContainerReader) {
            return this.m_Containers.size() > 0 || ((IncrementalDataContainerReader)((Object)this.m_Reader)).hasMoreData();
        }
        return this.m_Containers.size() > 0;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, ((Token)cont).getPayload().getClass()));
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Reader.cleanUp();
    }
}

