/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class AbstractDataProcessor
extends AbstractTransformer {
    private static final long serialVersionUID = 9062714175599800719L;
    protected PlaceholderDirectory m_Processing;
    protected PlaceholderDirectory m_Processed;
    protected PlaceholderDirectory m_Failed;
    protected String m_ProcessError;
    protected boolean m_UseTimestampDirs;
    protected SimpleDateFormat m_TimestampDirFormat;
    protected File m_DestinationFile;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processing", "processing", new PlaceholderDirectory("processing"));
        this.m_OptionManager.add("processed", "processed", new PlaceholderDirectory("processed"));
        this.m_OptionManager.add("failed", "failed", new PlaceholderDirectory("failed"));
        this.m_OptionManager.add("use-timestamp-dirs", "useTimestampDirs", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_TimestampDirFormat = new SimpleDateFormat("yyyyMMdd_HHmmss.SSS");
    }

    public void setProcessing(PlaceholderDirectory value) {
        this.m_Processing = value;
        this.reset();
    }

    public PlaceholderDirectory getProcessing() {
        return this.m_Processing;
    }

    public String processingTipText() {
        return "The directory where the data gets moved to for processing.";
    }

    public void setProcessed(PlaceholderDirectory value) {
        this.m_Processed = value;
        this.reset();
    }

    public PlaceholderDirectory getProcessed() {
        return this.m_Processed;
    }

    public String processedTipText() {
        return "The directory where the data gets moved to after successful processing.";
    }

    public void setFailed(PlaceholderDirectory value) {
        this.m_Failed = value;
        this.reset();
    }

    public PlaceholderDirectory getFailed() {
        return this.m_Failed;
    }

    public String failedTipText() {
        return "The directory where the data gets moved to after unsuccessful processing.";
    }

    public void setUseTimestampDirs(boolean value) {
        this.m_UseTimestampDirs = value;
        this.reset();
    }

    public boolean getUseTimestampDirs() {
        return this.m_UseTimestampDirs;
    }

    public String useTimestampDirsTipText() {
        return "If set to true, then the files/dirs being processed get encapsulated in timestamp directories to avoid name clashes.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File nextTimestampDir(File parent) {
        File result;
        do {
            if (!(result = new File(parent.getAbsolutePath() + File.separator + this.m_TimestampDirFormat.format(new Date()))).exists()) continue;
            result = null;
            try {
                AbstractDataProcessor abstractDataProcessor = this;
                synchronized (abstractDataProcessor) {
                    this.wait(100L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (result == null);
        return result;
    }

    protected File prepareData(File file) {
        File result = null;
        File source = file;
        File destBase = this.m_UseTimestampDirs ? this.nextTimestampDir(this.m_Processing) : this.m_Processing;
        File dest = new File(destBase.getAbsolutePath() + File.separator + source.getName());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Moving: From=" + source + ", To=" + dest);
        }
        try {
            if (this.m_UseTimestampDirs) {
                dest.getParentFile().mkdirs();
            }
            FileUtils.move(source, dest);
            result = dest;
        }
        catch (Exception e) {
            this.m_ProcessError = this.handleException("Error moving '" + source + "' to '" + dest + "': ", e);
        }
        return result;
    }

    protected abstract boolean processData(File var1);

    protected boolean postProcessData(File file, boolean success) {
        boolean result;
        File source = file;
        File destBase = success ? this.m_Processed : this.m_Failed;
        if (this.m_UseTimestampDirs) {
            destBase = this.nextTimestampDir(destBase);
        }
        this.m_DestinationFile = new File(destBase.getAbsolutePath() + File.separator + source.getName());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Moving: From=" + source + ", To=" + this.m_DestinationFile);
        }
        try {
            if (this.m_UseTimestampDirs) {
                this.m_DestinationFile.getParentFile().mkdirs();
            }
            FileUtils.move(source, this.m_DestinationFile);
            if (this.m_UseTimestampDirs) {
                file.getParentFile().delete();
            }
            result = true;
        }
        catch (Exception e) {
            result = false;
            this.m_ProcessError = this.handleException("Error moving '" + source + "' to '" + this.m_DestinationFile + "': ", e);
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        if (result == null && !this.m_Processing.isDirectory()) {
            result = "'" + this.m_Processing + "' is not a directory!";
        }
        if (result == null && !this.m_Processed.isDirectory()) {
            result = "'" + this.m_Processed + "' is not a directory!";
        }
        if (result == null && !this.m_Failed.isDirectory()) {
            result = "'" + this.m_Failed + "' is not a directory!";
        }
        if (result != null) {
            return result;
        }
        this.m_ProcessError = null;
        File file = this.m_InputToken.getPayload() instanceof String ? new File((String)this.m_InputToken.getPayload()) : (File)this.m_InputToken.getPayload();
        try {
            file = this.prepareData(file);
            result = this.m_ProcessError;
            if (result == null) {
                boolean success = this.processData(file);
                if (!success) {
                    result = this.m_ProcessError;
                }
                if (!(success = this.postProcessData(file, success))) {
                    result = this.m_ProcessError;
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to process data", e);
        }
        return result;
    }
}

