/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.id.IDHandler;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.DatabaseConnection;
import adams.flow.transformer.AbstractTransformer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public abstract class AbstractReportDbUpdater
extends AbstractTransformer {
    private static final long serialVersionUID = 1429977151568224156L;
    protected SQLStatement m_SQL;
    protected QueryType m_QueryType;
    protected String m_ColumnKey;
    protected String m_ColumnValue;
    protected boolean m_Lenient;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", new SQLStatement("select key,value from table where id = \"{ID}\""));
        this.m_OptionManager.add("query-type", "queryType", (Object)QueryType.KEY_VALUE);
        this.m_OptionManager.add("column-key", "columnKey", "key");
        this.m_OptionManager.add("column-value", "columnValue", "value");
        this.m_OptionManager.add("lenient", "lenient", false);
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement that selects the key-value pairs for the report; you can use the {ID} placeholder for the current handler's ID in your SQL statement (if it is an " + IDHandler.class.getName() + ").";
    }

    public void setQueryType(QueryType value) {
        this.m_QueryType = value;
        this.reset();
    }

    public QueryType getQueryType() {
        return this.m_QueryType;
    }

    public String queryTypeTipText() {
        return "The type of query that the SQL statement represents; multiple rows with key-value pairs (" + (Object)((Object)QueryType.KEY_VALUE) + ") or single row " + "with the column name as key (" + (Object)((Object)QueryType.COLUMN_AS_KEY) + ").";
    }

    public void setColumnKey(String value) {
        this.m_ColumnKey = value;
        this.reset();
    }

    public String getColumnKey() {
        return this.m_ColumnKey;
    }

    public String columnKeyTipText() {
        return "The name of the column containing the key for the key-value pairs to be added to the report.";
    }

    public void setColumnValue(String value) {
        this.m_ColumnValue = value;
        this.reset();
    }

    public String getColumnValue() {
        return this.m_ColumnValue;
    }

    public String columnValueTipText() {
        return "The name of the column containing the value for the key-value pairs to be added to the report.";
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
        this.reset();
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public String lenientTipText() {
        return "If enabled, error messages are suppressed in case empty resultsets are encountered.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Report.class, MutableReportHandler.class};
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "queryType", (Object)this.m_QueryType, "type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "SQL", Utils.shorten(this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), 50), ", query: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, "lenient", this.m_Lenient, "lenient", ", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    protected void addToReport(Report report, String key, Object value) {
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("key: " + key);
            this.getLogger().fine("value: " + value);
        }
        if (value == null) {
            return;
        }
        String str = value.toString();
        if (Utils.isDouble(str)) {
            report.addField(new Field(key, DataType.NUMERIC));
            report.setNumericValue(key, Double.parseDouble(str));
        } else if (Utils.isBoolean(str)) {
            report.addField(new Field(key, DataType.BOOLEAN));
            report.setBooleanValue(key, Boolean.parseBoolean(str.toLowerCase()));
        } else {
            report.addField(new Field(key, DataType.STRING));
            report.setStringValue(key, str);
        }
    }

    @Override
    protected String doExecute() {
        String result = null;
        Report report = null;
        MutableReportHandler handler = null;
        boolean isHandler = false;
        if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
            handler = (MutableReportHandler)this.m_InputToken.getPayload();
            isHandler = true;
            if (!handler.hasReport()) {
                handler.setReport(new Report());
            }
            report = handler.getReport();
        } else {
            report = (Report)this.m_InputToken.getPayload();
        }
        String query = null;
        try {
            query = this.m_SQL.getValue();
            if (isHandler && handler instanceof IDHandler) {
                query = query.replace("{ID}", ((IDHandler)((Object)handler)).getID());
            }
            query = this.getVariables().expand(query);
            if (this.isLoggingEnabled()) {
                this.getLogger().fine("query: " + query);
            }
            ResultSet rs = SQL.getSingleton(this.m_DatabaseConnection).getResultSet(query);
            boolean dataRead = false;
            switch (this.m_QueryType) {
                case KEY_VALUE: {
                    while (rs.next()) {
                        dataRead = true;
                        String key = rs.getObject(this.m_ColumnKey).toString();
                        Object value = rs.getObject(this.m_ColumnValue);
                        this.addToReport(report, key, value);
                    }
                    break;
                }
                case COLUMN_AS_KEY: {
                    if (!rs.next()) break;
                    dataRead = true;
                    ResultSetMetaData meta = rs.getMetaData();
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        if (meta.getColumnName(i).toLowerCase().equals(this.m_ColumnKey.toString())) continue;
                        String key = meta.getColumnName(i).toLowerCase();
                        Object value = rs.getObject(i);
                        this.addToReport(report, key, value);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled query type: " + (Object)((Object)this.m_QueryType));
                }
            }
            SQL.closeAll(rs);
            if (!dataRead && !this.m_Lenient) {
                result = "No data found: " + query;
            }
            if (isHandler) {
                handler.setReport(report);
                this.m_OutputToken = new Token(handler);
            } else {
                this.m_OutputToken = new Token(report);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read report data: " + query, e);
        }
        return result;
    }

    public static enum QueryType {
        KEY_VALUE,
        COLUMN_AS_KEY;

    }
}

