/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.AppendName;
import adams.flow.transformer.DirName;
import adams.flow.transformer.FileExtension;
import adams.flow.transformer.PrependDir;
import java.io.File;

public class BaseName
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = 4670761846363281951L;
    protected boolean m_RemoveExtension;

    @Override
    public String globalInfo() {
        return "Extracts the name of the file/directory passing through, i.e., any preceding directory gets stripped. It is also possible to remove the extension as well (everything after the last '.', dot included).";
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{PrependDir.class, AppendName.class, DirName.class, FileExtension.class};
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remove-extensions", "removeExtension", false);
    }

    public void setRemoveExtension(boolean value) {
        this.m_RemoveExtension = value;
        this.reset();
    }

    public boolean getRemoveExtension() {
        return this.m_RemoveExtension;
    }

    public String removeExtensionTipText() {
        return "If enabled, the file extension (everything following the last dot '.', dot including) gets removed as well.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "removeExtension", this.m_RemoveExtension, "remove extension");
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, String[].class, File.class, File[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        boolean array = this.m_InputToken.getPayload().getClass().isArray();
        PlaceholderFile[] files = FileUtils.toPlaceholderFileArray(this.m_InputToken.getPayload());
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
            if (!this.m_RemoveExtension) continue;
            strings[i] = FileUtils.replaceExtension(strings[i], "");
        }
        this.m_OutputToken = array ? new Token(strings) : new Token(strings[0]);
        return result;
    }
}

