/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class CallableTransformer
extends AbstractCallableActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -4898610818562897692L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Feeds tokens into a callable transformer and broadcasts the generated output tokens.";
    }

    @Override
    protected AbstractActor findCallableActor() {
        AbstractActor result = super.findCallableActor();
        if (result != null && !ActorUtils.isTransformer(result)) {
            this.getLogger().severe("Callable actor '" + result.getFullName() + "' is not a transformer" + (this.m_CallableActor == null ? "!" : this.m_CallableActor.getClass().getName()));
            result = null;
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_InputToken != null) {
            result.put(BACKUP_INPUT, this.m_InputToken);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
    }

    @Override
    public Class[] accepts() {
        if (this.m_CallableActor != null) {
            return ((InputConsumer)((Object)this.m_CallableActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public Class[] generates() {
        if (this.m_CallableActor != null) {
            return ((OutputProducer)((Object)this.m_CallableActor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String executeCallableActor() {
        if (this.m_InputToken != null) {
            ((InputConsumer)((Object)this.m_CallableActor)).input(this.m_InputToken);
        }
        String result = this.m_CallableActor.execute();
        return result;
    }

    @Override
    public Token output() {
        this.m_InputToken = null;
        return ((OutputProducer)((Object)this.m_CallableActor)).output();
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_CallableActor != null && ((OutputProducer)((Object)this.m_CallableActor)).hasPendingOutput();
    }
}

