/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.featureconverter.Text;
import adams.flow.container.FeatureConverterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;

public class ConvertFeatures
extends AbstractTransformer {
    private static final long serialVersionUID = 7491100983182267771L;
    protected AbstractFeatureConverter m_Converter;
    protected String m_MergeFormat;
    protected OutputType m_OutputType;

    @Override
    public String globalInfo() {
        return "Turns the raw features generated by a feature converter (stored in a " + FeatureConverterContainer.class.getName() + ") " + "into a specific format using the user-defined feature converter.\n" + "If an array of containers is received, the get merged first, i.e., " + "placed side-by-side.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("converter", "converter", new Text());
        this.m_OptionManager.add("merge-format", "mergeFormat", "@-$");
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.HEADER);
    }

    public void setConverter(AbstractFeatureConverter value) {
        this.m_Converter = value;
        this.reset();
    }

    public AbstractFeatureConverter getConverter() {
        return this.m_Converter;
    }

    public String converterTipText() {
        return "The converter to use for turning the raw features into a specific format.";
    }

    public void setMergeFormat(String value) {
        if (value != null && value.trim().length() > 0) {
            this.m_MergeFormat = value;
            this.reset();
        } else {
            this.getLogger().warning("Merge format cannot be null or empty!");
        }
    }

    public String getMergeFormat() {
        return this.m_MergeFormat;
    }

    public String mergeFormatTipText() {
        return "The format to use for merging multiple feature containers before converting them; use '@' for the dataset name, '#' for the 1-based array index and '$' for the feature name.";
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "What data to generate; in case of " + (Object)((Object)OutputType.BOTH) + " an array with " + (Object)((Object)OutputType.HEADER) + " and " + (Object)((Object)OutputType.ROW) + " is output.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "converter", this.m_Converter, "converter: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "mergeFormat", this.m_MergeFormat, ", format: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "outputType", (Object)this.m_OutputType, ", output: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{FeatureConverterContainer.class, FeatureConverterContainer[].class};
    }

    @Override
    public Class[] generates() {
        switch (this.m_OutputType) {
            case HEADER: {
                return new Class[]{this.m_Converter.getDatasetFormat()};
            }
            case ROW: {
                return new Class[]{this.m_Converter.getRowFormat()};
            }
            case BOTH: {
                return new Class[]{Object[].class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
    }

    @Override
    protected String doExecute() {
        String result = null;
        HeaderDefinition headerNew = null;
        ArrayList<Object> rowNew = null;
        if (this.m_InputToken.getPayload() instanceof FeatureConverterContainer) {
            FeatureConverterContainer cont = (FeatureConverterContainer)this.m_InputToken.getPayload();
            headerNew = (HeaderDefinition)cont.getValue("Header");
            rowNew = (List)cont.getValue("Row");
        } else {
            FeatureConverterContainer[] conts = (FeatureConverterContainer[])this.m_InputToken.getPayload();
            headerNew = new HeaderDefinition();
            rowNew = new ArrayList();
            for (int i = 0; i < conts.length; ++i) {
                HeaderDefinition header = (HeaderDefinition)conts[i].getValue("Header");
                List row = (List)conts[i].getValue("Row");
                for (int n = 0; n < header.size(); ++n) {
                    String name = this.m_MergeFormat;
                    name = name.replace("@", header.getDataset());
                    name = name.replace("#", "" + (i + 1));
                    name = name.replace("$", header.getName(n));
                    headerNew.add(name, header.getType(n));
                }
                if (rowNew == null) continue;
                if (row == null) {
                    rowNew = null;
                    continue;
                }
                rowNew.addAll(row);
            }
        }
        switch (this.m_OutputType) {
            case HEADER: {
                this.m_OutputToken = new Token(this.m_Converter.generateHeader(headerNew));
                break;
            }
            case ROW: {
                if (rowNew == null) break;
                if (this.m_Converter.getHeaderDefinition() == null) {
                    this.m_Converter.generateHeader(headerNew);
                }
                this.m_OutputToken = new Token(this.m_Converter.generateRow(rowNew));
                break;
            }
            case BOTH: {
                this.m_OutputToken = new Token(new Object[]{this.m_Converter.generateHeader(headerNew), rowNew == null ? null : this.m_Converter.generateRow(rowNew)});
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
        return result;
    }

    public static enum OutputType {
        HEADER,
        ROW,
        BOTH;

    }
}

