/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.io.AbstractFilenameGenerator;
import adams.core.io.FixedFilenameGenerator;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class FilenameGenerator
extends AbstractTransformer
implements ClassCrossReference {
    private static final long serialVersionUID = -5969795295785887230L;
    protected AbstractFilenameGenerator m_Generator;
    protected boolean m_Absolute;

    @Override
    public String globalInfo() {
        return "Passes the incoming token through the generator to generate and forward a filename.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", new FixedFilenameGenerator());
        this.m_OptionManager.add("absolute", "absolute", true);
    }

    @Override
    public Class[] getClassCrossReferences() {
        return new Class[]{adams.flow.source.FilenameGenerator.class};
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "generator", this.m_Generator);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "absolute", this.m_Absolute ? ", absolute" : ", placeholder");
        return result;
    }

    public void setGenerator(AbstractFilenameGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractFilenameGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for generating the filename.";
    }

    public void setAbsolute(boolean value) {
        this.m_Absolute = value;
        this.reset();
    }

    public boolean getAbsolute() {
        return this.m_Absolute;
    }

    public String absoluteTipText() {
        return "Whether to output absolute or placeholder filenames.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            String filename = this.m_Generator.generate(this.m_InputToken.getPayload());
            PlaceholderFile file = new PlaceholderFile(filename);
            this.m_OutputToken = this.m_Absolute ? new Token(file.getAbsolutePath()) : new Token(file.toString());
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate filename!", e);
        }
        return result;
    }
}

