/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class GetStorageValue
extends AbstractTransformer
implements StorageUser {
    private static final long serialVersionUID = 3086015634110488066L;
    protected String m_Cache;

    @Override
    public String globalInfo() {
        return "Retrieves a value from internal storage using the incoming string token as name.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to get the value from; uses the regular storage if left empty.";
    }

    @Override
    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    @Override
    public String getQuickInfo() {
        String result = null;
        String value = QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.length() > 0 ? this.m_Cache : "", " cache: ");
        if (value != null) {
            result = value;
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        StorageName name = new StorageName((String)this.m_InputToken.getPayload());
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Retrieving" + (this.m_Cache.isEmpty() ? "" : " (cache: " + this.m_Cache + ")") + ": '" + name + "'");
        }
        Object value = this.m_Cache.length() == 0 ? this.getStorageHandler().getStorage().get(name) : this.getStorageHandler().getStorage().get(this.m_Cache, name);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Value retrieved: " + value);
        }
        if (value != null) {
            this.m_OutputToken = new Token(value);
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }
}

