/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.List;

public class MatchReportFields
extends AbstractArrayProvider {
    private static final long serialVersionUID = -6237324482439105653L;
    protected BaseRegExp m_RegExp;

    @Override
    public String globalInfo() {
        return "Outputs all fields that match the regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", this.getDefaultRegularExpression());
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputArray", this.m_OutputArray, "output array"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    @Override
    public String outputArrayTipText() {
        return "If enabled, outputs the fields as array.";
    }

    protected BaseRegExp getDefaultRegularExpression() {
        return new BaseRegExp(".*");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match against the field names.";
    }

    @Override
    protected Class getItemClass() {
        return AbstractField.class;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Report report = this.m_InputToken.getPayload() instanceof ReportHandler ? ((ReportHandler)this.m_InputToken.getPayload()).getReport() : (Report)this.m_InputToken.getPayload();
        this.m_Queue.clear();
        if (report != null) {
            List<AbstractField> fields = report.getFields();
            for (AbstractField field : fields) {
                if (!this.m_RegExp.isMatch(field.getName())) continue;
                this.m_Queue.add(field);
            }
        }
        return result;
    }
}

