/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.RoundingType;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class Round
extends AbstractTransformer {
    private static final long serialVersionUID = 5849681965859916196L;
    protected RoundingType m_Action;

    @Override
    public String globalInfo() {
        return "Performs 'round', 'ceiling' or 'floor' on double tokens and generates integers.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)RoundingType.ROUND);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "action", (Object)this.m_Action);
    }

    public void setAction(RoundingType value) {
        this.m_Action = value;
        this.reset();
    }

    public RoundingType getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to perform on the doubles passing through.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Double.class, Double[].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class, Integer[].class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Double[] doubles = null;
        try {
            boolean isArray = this.m_InputToken.getPayload() instanceof Double[];
            doubles = !isArray ? new Double[]{(Double)this.m_InputToken.getPayload()} : (Double[])this.m_InputToken.getPayload();
            Integer[] integers = new Integer[doubles.length];
            block7: for (int i = 0; i < doubles.length; ++i) {
                switch (this.m_Action) {
                    case ROUND: {
                        integers[i] = (int)Math.round(doubles[i]);
                        continue block7;
                    }
                    case CEILING: {
                        integers[i] = (int)Math.ceil(doubles[i]);
                        continue block7;
                    }
                    case FLOOR: {
                        integers[i] = (int)Math.floor(doubles[i]);
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled action: " + (Object)((Object)this.m_Action));
                    }
                }
            }
            this.m_OutputToken = !isArray ? new Token(new Integer(integers[0])) : new Token(integers);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to round" + Utils.arrayToString(doubles), e);
        }
        return result;
    }
}

