/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.chooser.FontChooser;
import adams.gui.chooser.TextFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public abstract class AbstractTextAreaPanelWithAdvancedSyntaxHighlighting
extends BasePanel {
    private static final long serialVersionUID = -6446220610454192959L;
    protected RSyntaxTextArea m_TextArea;
    protected RTextScrollPane m_ScrollPane;
    protected boolean m_Modified;
    protected boolean m_IgnoreChanges;
    protected transient TextFileChooser m_FileChooser;
    protected String m_LastFind;
    protected HashSet<ChangeListener> m_ChangeListeners;
    protected File m_CurrentFile;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_CurrentFile = null;
        this.m_ChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextArea = this.newTextArea();
        this.m_ScrollPane = this.newScrollPane(this.m_TextArea);
        this.add((Component)this.m_ScrollPane, "Center");
        this.m_TextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractTextAreaPanelWithAdvancedSyntaxHighlighting.this.m_Modified = true;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractTextAreaPanelWithAdvancedSyntaxHighlighting.this.m_Modified = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractTextAreaPanelWithAdvancedSyntaxHighlighting.this.m_Modified = true;
            }
        });
        this.m_TextArea.getDocument().addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                AbstractTextAreaPanelWithAdvancedSyntaxHighlighting.this.m_Modified = true;
                AbstractTextAreaPanelWithAdvancedSyntaxHighlighting.this.notifyChangeListeners();
            }
        });
        this.setSize(600, 800);
    }

    protected abstract String getSyntaxStyle();

    protected RSyntaxTextArea newTextArea() {
        RSyntaxTextArea result = new RSyntaxTextArea();
        result.setLineWrap(false);
        result.setAutoIndentEnabled(true);
        result.setAntiAliasingEnabled(true);
        result.setCodeFoldingEnabled(true);
        result.setBracketMatchingEnabled(false);
        result.setSyntaxEditingStyle(this.getSyntaxStyle());
        return result;
    }

    protected RTextScrollPane newScrollPane(RSyntaxTextArea textArea) {
        RTextScrollPane result = new RTextScrollPane((Component)textArea);
        result.setLineNumbersEnabled(true);
        result.setFoldIndicatorEnabled(true);
        return result;
    }

    protected TextFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new TextFileChooser();
        }
        return this.m_FileChooser;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
        this.notifyChangeListeners();
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setContent(String value) {
        this.m_TextArea.setText(value);
    }

    public String getContent() {
        return this.m_TextArea.getText();
    }

    public void setEditable(boolean value) {
        this.m_TextArea.setEditable(value);
    }

    public boolean isEditable() {
        return this.m_TextArea.isEditable();
    }

    public void setTextFont(Font value) {
        this.m_TextArea.setFont(value);
    }

    public Font getTextFont() {
        return this.m_TextArea.getFont();
    }

    public String getLastFind() {
        return this.m_LastFind;
    }

    public RSyntaxTextArea getTextArea() {
        return this.m_TextArea;
    }

    public Document getDocument() {
        return this.m_TextArea.getDocument();
    }

    public void setCaretPosition(int value) {
        this.m_TextArea.setCaretPosition(value);
    }

    public int getCaretPosition() {
        return this.m_TextArea.getCaretPosition();
    }

    public void setLineWrap(boolean value) {
        this.m_TextArea.setLineWrap(value);
    }

    public boolean getLineWrap() {
        return this.m_TextArea.getLineWrap();
    }

    public boolean checkForModified() {
        boolean result;
        boolean bl = result = !this.isModified();
        if (!result) {
            String msg = "Content not saved - save?";
            int retVal = GUIHelper.showConfirmMessage(this, msg, "Content not saved");
            switch (retVal) {
                case 0: {
                    this.saveAs();
                    result = !this.isModified();
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = false;
                }
            }
        }
        return result;
    }

    public void open() {
        int retVal = this.getFileChooser().showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.open(this.getFileChooser().getSelectedFile(), this.getFileChooser().getEncoding());
    }

    public void open(File file) {
        this.open(file, null);
    }

    public void open(File file, String encoding) {
        if (encoding == null || encoding.isEmpty()) {
            encoding = "UTF-8";
        }
        List<String> content = FileUtils.loadFromFile(file, encoding);
        this.setContent(Utils.flatten(content, "\n"));
        this.setModified(false);
        this.m_CurrentFile = file;
        this.notifyChangeListeners();
    }

    public void save() {
        if (this.m_CurrentFile == null) {
            this.saveAs();
        } else {
            this.save(this.m_CurrentFile);
        }
    }

    public void saveAs() {
        int retVal = this.getFileChooser().showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        this.save(this.getFileChooser().getSelectedFile());
    }

    protected void save(File file) {
        if (!FileUtils.writeToFile(file.getAbsolutePath(), (Object)this.m_TextArea.getText(), false)) {
            GUIHelper.showErrorMessage(this, "Error saving content to file '" + file + "'!");
        } else {
            this.m_CurrentFile = file;
            this.m_Modified = false;
        }
        this.notifyChangeListeners();
    }

    public void clear() {
        try {
            this.m_TextArea.getDocument().remove(0, this.m_TextArea.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Modified = false;
        this.notifyChangeListeners();
    }

    public boolean canUndo() {
        try {
            return this.m_TextArea.canUndo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void undo() {
        try {
            if (this.m_TextArea.canUndo()) {
                this.m_TextArea.undoLastAction();
            }
            if (!this.m_TextArea.canUndo()) {
                this.m_Modified = false;
            }
            this.notifyChangeListeners();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canRedo() {
        try {
            return this.m_TextArea.canRedo();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void redo() {
        try {
            if (this.m_TextArea.canRedo()) {
                this.m_TextArea.redoLastAction();
                this.m_Modified = true;
                this.notifyChangeListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canCut() {
        return this.isEditable() && this.m_TextArea.getSelectedText() != null;
    }

    public void cut() {
        this.m_TextArea.cut();
        this.notifyChangeListeners();
    }

    public boolean canCopy() {
        return this.m_TextArea.getSelectedText() != null;
    }

    public void copy() {
        if (this.m_TextArea.getSelectedText() == null) {
            GUIHelper.copyToClipboard(this.m_TextArea.getText());
        } else {
            this.m_TextArea.copy();
        }
    }

    public boolean canPaste() {
        return this.isEditable() && GUIHelper.canPasteStringFromClipboard();
    }

    public void paste() {
        this.m_TextArea.paste();
        this.notifyChangeListeners();
    }

    public void selectAll() {
        this.m_TextArea.selectAll();
    }

    public void find() {
        String search = GUIHelper.showInputDialog(GUIHelper.getParentComponent(this), "Enter search string", this.m_LastFind);
        if (search == null) {
            return;
        }
        int index = this.m_TextArea.getText().indexOf(search, this.m_TextArea.getCaretPosition());
        if (index > -1) {
            this.m_LastFind = search;
            this.m_TextArea.setCaretPosition(index + search.length());
            this.m_TextArea.setSelectionStart(index);
            this.m_TextArea.setSelectionEnd(index + search.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + search + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void findNext() {
        int index = this.m_TextArea.getText().indexOf(this.m_LastFind, this.m_TextArea.getCaretPosition());
        if (index > -1) {
            this.m_TextArea.setCaretPosition(index + this.m_LastFind.length());
            this.m_TextArea.setSelectionStart(index);
            this.m_TextArea.setSelectionEnd(index + this.m_LastFind.length());
        } else {
            GUIHelper.showErrorMessage(this, "Search string '" + this.m_LastFind + "' not found!");
        }
        this.notifyChangeListeners();
    }

    public void printText() {
        try {
            this.m_TextArea.print(null, null, true, null, null, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "Failed to print:\n" + ex;
            if (this.getParentDialog() != null) {
                GUIHelper.showErrorMessage(this.getParentDialog(), msg);
            }
            GUIHelper.showErrorMessage(this.getParentFrame(), msg);
        }
    }

    public void selectFont() {
        FontChooser chooser = this.getParentDialog() != null ? new FontChooser(this.getParentDialog()) : new FontChooser(this.getParentFrame());
        chooser.setCurrent(this.getFont());
        chooser.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        chooser.setVisible(true);
        this.setTextFont(chooser.getCurrent());
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    protected synchronized void notifyChangeListeners() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(e);
        }
    }
}

