/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.core.BaseList;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class BaseMultiPagePane
extends BasePanel {
    private static final long serialVersionUID = 887135856139374858L;
    protected DefaultListModel<String> m_ModelNames;
    protected BaseList m_ListNames;
    protected BaseScrollPane m_ScrollPaneNames;
    protected BaseSplitPane m_SplitPane;
    protected JPanel m_PageComponent;
    protected HashMap<String, Component> m_PageLookup;
    protected List<String> m_PageOrder;
    protected int m_SelectedPage;
    protected HashSet<ChangeListener> m_ChangeListeners;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PageLookup = new HashMap();
        this.m_PageOrder = new ArrayList<String>();
        this.m_SelectedPage = -1;
        this.m_ChangeListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setResizeWeight(0.0);
        this.m_SplitPane.setDividerLocation(200);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_ModelNames = new DefaultListModel();
        this.m_ListNames = new BaseList((ListModel)this.m_ModelNames);
        this.m_ListNames.setSelectionMode(0);
        this.m_ListNames.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseMultiPagePane.this.updatePage();
            }
        });
        this.m_ScrollPaneNames = new BaseScrollPane(this.m_ListNames);
        this.m_SplitPane.setLeftComponent(this.m_ScrollPaneNames);
        this.m_PageComponent = new JPanel(new BorderLayout());
        this.m_SplitPane.setRightComponent(this.m_PageComponent);
    }

    public BaseSplitPane getSplitPane() {
        return this.m_SplitPane;
    }

    @Override
    public void removeAll() {
        this.m_PageOrder.clear();
        this.m_PageLookup.clear();
        this.m_ModelNames.clear();
        this.m_SelectedPage = -1;
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    protected void updatePage() {
        this.m_PageComponent.removeAll();
        if (this.m_ListNames.getSelectedIndex() != -1) {
            this.m_SelectedPage = this.m_PageOrder.indexOf(this.m_ListNames.getSelectedValue());
            this.m_PageComponent.add(this.m_PageLookup.get(this.m_PageOrder.get(this.m_SelectedPage)));
        } else if (this.m_PageOrder.size() > 0) {
            this.m_SelectedPage = 0;
            this.m_PageComponent.add(this.m_PageLookup.get(this.m_PageOrder.get(this.m_SelectedPage)));
        }
        this.invalidate();
        this.validate();
        this.repaint();
        this.notifyChangeListeners(new ChangeEvent(this));
    }

    public void addPage(String name, Component page) {
        this.m_PageLookup.put(name, page);
        if (this.m_PageOrder.contains(name)) {
            this.m_PageOrder.remove(name);
        }
        this.m_PageOrder.add(name);
        if (this.m_ModelNames.contains(name)) {
            this.m_ModelNames.removeElement(name);
        }
        this.m_ModelNames.addElement(name);
        if (this.m_SelectedPage == -1) {
            this.m_ListNames.setSelectedValue(name, true);
        }
    }

    public void removePageAt(int index) {
        if (index < 0 || index >= this.m_PageOrder.size()) {
            return;
        }
        String name = this.m_PageOrder.get(index);
        this.m_PageComponent.removeAll();
        this.m_PageOrder.remove(index);
        this.m_PageLookup.remove(name);
        this.m_ModelNames.removeElement(name);
        if (index == this.m_SelectedPage && this.m_PageOrder.size() > 0) {
            if (this.m_SelectedPage == this.m_PageOrder.size()) {
                this.m_ListNames.setSelectedIndex(this.m_SelectedPage - 1);
            } else {
                this.m_ListNames.setSelectedIndex(this.m_SelectedPage);
            }
        }
    }

    public boolean removeSelectedPage() {
        if (this.m_SelectedPage == -1) {
            return false;
        }
        this.removePageAt(this.m_SelectedPage);
        return true;
    }

    public int getPageCount() {
        return this.m_PageLookup.size();
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners(ChangeEvent e) {
        ChangeListener[] listeners;
        for (ChangeListener listener : listeners = this.m_ChangeListeners.toArray(new ChangeListener[this.m_ChangeListeners.size()])) {
            listener.stateChanged(e);
        }
    }
}

