/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.gui.core.SpreadSheetTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SpreadSheetColumnComboBox
extends JComboBox {
    private static final long serialVersionUID = 5256160332596403161L;
    protected SpreadSheetTable m_Table;

    public SpreadSheetColumnComboBox(SpreadSheetTable table) {
        this.m_Table = table;
        this.update();
        this.m_Table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SpreadSheetColumnComboBox.this.update();
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpreadSheetColumnComboBox.this.getSelectedIndex() == -1) {
                    return;
                }
                ColumnContainer cont = (ColumnContainer)SpreadSheetColumnComboBox.this.getSelectedItem();
                int row = SpreadSheetColumnComboBox.this.m_Table.getSelectedRow();
                if (row == -1) {
                    row = 0;
                }
                int col = cont.getColumn();
                if (SpreadSheetColumnComboBox.this.m_Table.getShowRowColumn()) {
                    ++col;
                }
                SpreadSheetColumnComboBox.this.m_Table.showCell(row, col);
            }
        });
    }

    protected synchronized void update() {
        ArrayList<ColumnContainer> columns = new ArrayList<ColumnContainer>();
        HeaderRow row = this.m_Table.toSpreadSheet().getHeaderRow();
        for (int i = 0; i < row.getCellCount(); ++i) {
            if (!row.hasCell(i) || row.getCell(i).isMissing()) continue;
            Cell cell = row.getCell(i);
            columns.add(new ColumnContainer(cell.getContent(), i));
        }
        Collections.sort(columns);
        this.setModel(new DefaultComboBoxModel<ColumnContainer>(columns.toArray(new ColumnContainer[columns.size()])));
    }

    public static class ColumnContainer
    implements Serializable,
    Comparable<ColumnContainer> {
        private static final long serialVersionUID = 8359213625873465324L;
        protected String m_Name;
        protected String m_NameLowerCase;
        protected int m_Column;

        public ColumnContainer(String name, int column) {
            this.m_Name = name;
            this.m_NameLowerCase = name.toLowerCase();
            this.m_Column = column;
        }

        public String getName() {
            return this.m_Name;
        }

        public String getNameLowerCase() {
            return this.m_NameLowerCase;
        }

        public int getColumn() {
            return this.m_Column;
        }

        @Override
        public int compareTo(ColumnContainer o) {
            if (o == null) {
                return 1;
            }
            int result = this.getNameLowerCase().compareTo(o.getNameLowerCase());
            if (result == 0) {
                result = new Integer(this.getColumn()).compareTo(o.getColumn());
            }
            return result;
        }

        public String toString() {
            return this.m_Name + " [" + (this.m_Column + 1) + "]";
        }
    }
}

