/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.dotnotationtree;

import adams.core.base.BaseString;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.DragAndDropTree;
import adams.gui.core.MouseUtils;
import adams.gui.core.TransferableString;
import adams.gui.core.dotnotationtree.AbstractInfoNode;
import adams.gui.core.dotnotationtree.AbstractInfoNodeGenerator;
import adams.gui.core.dotnotationtree.AbstractItemFilter;
import adams.gui.core.dotnotationtree.DotNotationNode;
import adams.gui.core.dotnotationtree.DotNotationRenderer;
import adams.gui.core.dotnotationtree.PopupMenuHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DotNotationTree<N extends DotNotationNode>
extends DragAndDropTree {
    private static final long serialVersionUID = 1489354474021395304L;
    protected List<String> m_Items;
    protected String m_Search;
    protected boolean m_Compress;
    protected AbstractItemFilter m_Filter;
    protected List<AbstractInfoNodeGenerator> m_InfoNodeGenerators;
    protected PopupMenuHandler m_PopupMenuHandler;
    protected boolean m_Sorted;
    protected int m_SelectionMode;

    public DotNotationTree() {
        this.setShowsRootHandles(true);
        this.setCellRenderer(this.getDefaultRenderer());
        this.setToggleClickCount(0);
        this.m_Items = new ArrayList<String>();
        this.m_Search = "";
        this.m_Compress = true;
        this.m_Filter = null;
        this.m_PopupMenuHandler = null;
        this.m_Sorted = false;
        this.m_InfoNodeGenerators = new ArrayList<AbstractInfoNodeGenerator>();
        this.m_SelectionMode = 1;
        this.setItems(new ArrayList<String>());
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e) && DotNotationTree.this.m_PopupMenuHandler != null) {
                    e.consume();
                    DotNotationTree.this.showPopup(e);
                } else {
                    super.mouseClicked(e);
                }
            }
        });
    }

    public void setSelectionMode(int value) {
        if (value == 1 || value == 2 || value == 4) {
            this.m_SelectionMode = value;
            this.getSelectionModel().setSelectionMode(value);
        } else {
            System.err.println("Unknown selection mode: " + value);
        }
    }

    public int getSelectionMode() {
        return this.m_SelectionMode;
    }

    protected TreeCellRenderer getDefaultRenderer() {
        return new DotNotationRenderer();
    }

    protected void showPopup(MouseEvent e) {
        JPopupMenu menu = null;
        BaseTreeNode node = null;
        TreePath path = this.getClosestPathForLocation(e.getX(), e.getY());
        if (path != null) {
            node = (BaseTreeNode)path.getLastPathComponent();
            menu = node instanceof AbstractInfoNode ? this.m_PopupMenuHandler.getInfoNodePopup((AbstractInfoNode)node) : this.m_PopupMenuHandler.getItemNodePopup((DotNotationNode)node, ((DotNotationNode)node).isItemLeaf());
        }
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    protected boolean isDragEnabled() {
        return true;
    }

    @Override
    protected boolean canStartDrag(BaseTreeNode[] source) {
        return source.length == 1 && source[0] instanceof DotNotationNode;
    }

    @Override
    protected BaseTreeNode[] newTreeNodes(Transferable data) {
        BaseTreeNode[] result = new BaseTreeNode[1];
        try {
            result[0] = this.newNode(((TransferableString)data.getTransferData(DataFlavor.stringFlavor)).getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            result[0] = new DotNotationNode("-ERROR-");
        }
        return result;
    }

    public DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.getModel();
    }

    public void setSorted(boolean value) {
        if (this.m_Sorted != value) {
            this.m_Sorted = value;
            if (this.m_Sorted) {
                ArrayList<String> items = new ArrayList<String>(this.m_Items);
                this.setItems(items);
            }
        }
    }

    public boolean isSorted() {
        return this.m_Sorted;
    }

    protected List<String> applySearchFilter(List<String> items) {
        List<String> result;
        if (this.m_Search.length() == 0) {
            result = items;
        } else {
            String search = this.m_Search.toLowerCase();
            result = new ArrayList<String>();
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i).toLowerCase().indexOf(search) <= -1) continue;
                result.add(items.get(i));
            }
        }
        return result;
    }

    protected boolean hasRootNodeLabel() {
        return this.getRootNodeLabel() != null;
    }

    protected String getRootNodeLabel() {
        return "root";
    }

    protected String getRootPart(String item) {
        return this.splitItem(item)[0];
    }

    protected N findRoot(N root, String item) {
        TreeNode result = null;
        String prefix = this.getRootPart(item);
        if (root == null) {
            if (this.hasRootNodeLabel()) {
                root = this.newNode(this.getRootNodeLabel());
                N child = this.newNode(prefix);
                ((DefaultMutableTreeNode)root).add((MutableTreeNode)child);
            } else {
                root = this.newNode(prefix);
            }
            result = (TreeNode)root;
        } else {
            DotNotationNode child;
            int i;
            if (this.hasRootNodeLabel()) {
                for (i = 0; i < ((DefaultMutableTreeNode)root).getChildCount(); ++i) {
                    child = (DotNotationNode)((DefaultMutableTreeNode)root).getChildAt(i);
                    if (!child.isLabelMatch(prefix)) continue;
                    result = (TreeNode)root;
                    break;
                }
            } else {
                result = (TreeNode)root;
            }
            if (result == null) {
                for (i = 0; i < ((DefaultMutableTreeNode)root).getChildCount(); ++i) {
                    child = (DotNotationNode)((DefaultMutableTreeNode)root).getChildAt(i);
                    if (child.getLabel().compareTo(prefix) != 1) continue;
                    ((DefaultMutableTreeNode)root).insert((MutableTreeNode)this.newNode(prefix), i);
                    break;
                }
                if (result == null) {
                    ((DefaultMutableTreeNode)root).add((MutableTreeNode)this.newNode(prefix));
                }
                result = (TreeNode)root;
            }
        }
        if (this.getTreeModel().getRoot() == null) {
            this.setModel(new DefaultTreeModel(result));
        }
        return (N)result;
    }

    protected N newNode(String label) {
        return (N)new DotNotationNode(label);
    }

    protected void postAddLeaf(N node, String item) {
        for (int n = 0; n < this.m_InfoNodeGenerators.size(); ++n) {
            this.m_InfoNodeGenerators.get(n).process((DotNotationNode)node, item);
        }
    }

    protected String[] splitItem(String item) {
        return item.split("\\.");
    }

    public String getSeparator() {
        return ".";
    }

    protected N addItem(N root, String item) {
        Object node;
        int i;
        Object result = null;
        if (root == null) {
            return (N)result;
        }
        String[] parts = this.splitItem(item);
        for (i = 0; i < ((DefaultMutableTreeNode)root).getChildCount(); ++i) {
            node = (DotNotationNode)((DefaultMutableTreeNode)root).getChildAt(i);
            if (!((DotNotationNode)node).isLabelMatch(parts[0])) continue;
            root = node;
            break;
        }
        node = root;
        for (i = 1; i < parts.length; ++i) {
            DotNotationNode child;
            boolean found = false;
            for (int n = 0; n < ((DefaultMutableTreeNode)node).getChildCount(); ++n) {
                child = (DotNotationNode)((DefaultMutableTreeNode)node).getChildAt(n);
                if (!child.isLabelMatch(parts[i])) continue;
                found = true;
                node = child;
                break;
            }
            if (!found) {
                child = this.newNode(parts[i]);
                ((DefaultMutableTreeNode)node).add(child);
                node = child;
            }
            if (i != parts.length - 1 || !((DotNotationNode)node).isLabelMatch(parts[i])) continue;
            result = node;
            this.postAddLeaf(result, item);
        }
        return (N)result;
    }

    protected Object[] findItem(N root, String[] parts) {
        Object[] result = null;
        for (int i = 0; i < ((DefaultMutableTreeNode)root).getChildCount(); ++i) {
            DotNotationNode node = (DotNotationNode)((DefaultMutableTreeNode)root).getChildAt(i);
            String[] itemParts = this.splitItem(node.getLabel());
            boolean match = true;
            int max = Math.min(itemParts.length, parts.length);
            for (int n = 0; n < max; ++n) {
                if (itemParts[n].equals(parts[n])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            String[] newParts = new String[Math.max(itemParts.length, parts.length) - max];
            System.arraycopy(parts, max, newParts, 0, newParts.length);
            result = new Object[]{node, newParts};
            break;
        }
        return result;
    }

    protected N findItem(N root, String item) {
        N result = null;
        if (root == null) {
            return result;
        }
        String[] parts = this.splitItem(item);
        String[] newParts = null;
        Object[] search = this.findItem(root, parts);
        if (search != null) {
            root = (DotNotationNode)search[0];
            newParts = (String[])search[1];
        }
        if ((parts = newParts) == null) {
            return null;
        }
        Object node = root;
        do {
            if ((search = this.findItem(node, parts)) == null) continue;
            node = (DotNotationNode)search[0];
            parts = (String[])search[1];
            if (parts.length != 0) continue;
            result = node;
        } while (search != null && result == null);
        return result;
    }

    protected void compress(N root) {
        DotNotationNode child;
        if (((DefaultMutableTreeNode)root).getChildCount() == 1 && ((DefaultMutableTreeNode)root).getChildAt(0) instanceof DotNotationNode && !(child = (DotNotationNode)((DefaultMutableTreeNode)root).getChildAt(0)).isLeaf()) {
            DotNotationNode parent = (DotNotationNode)((DefaultMutableTreeNode)root).getParent();
            if (parent != null) {
                N newRoot = this.newNode(((DotNotationNode)root).getLabel() + this.getSeparator() + child.getLabel());
                while (child.getChildCount() > 0) {
                    ((DefaultMutableTreeNode)newRoot).add((BaseTreeNode)child.getChildAt(0));
                }
                parent.insert((MutableTreeNode)newRoot, parent.getIndex((TreeNode)root));
                parent.remove((MutableTreeNode)root);
                child = newRoot;
            }
            this.compress(child);
        }
    }

    protected void compress() {
        DotNotationNode root = (DotNotationNode)this.getTreeModel().getRoot();
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.compress((DotNotationNode)root.getChildAt(i));
            }
        }
    }

    protected void buildTree() {
        this.setModel(new DefaultTreeModel(null));
        List<String> items = this.applySearchFilter(this.applyItemFilter(this.m_Items));
        N root = null;
        for (int i = 0; i < items.size(); ++i) {
            root = this.findRoot(root, items.get(i));
            this.addItem(root, items.get(i));
        }
        if (this.m_Compress) {
            this.compress();
        }
        this.getTreeModel().reload();
        this.postBuildTree();
    }

    protected void postBuildTree() {
        this.getSelectionModel().setSelectionMode(this.m_SelectionMode);
    }

    public void setCompress(boolean value) {
        if (this.m_Compress != value) {
            this.m_Compress = value;
            this.buildTree();
        }
    }

    public boolean getCompress() {
        return this.m_Compress;
    }

    public void setFilter(AbstractItemFilter value) {
        this.m_Filter = value;
        this.buildTree();
    }

    public AbstractItemFilter getFilter() {
        return this.m_Filter;
    }

    public boolean hasItem(String item) {
        return this.m_Items.contains(item);
    }

    public void addItem(String item) {
        DotNotationNode added = this.addItem(this.findRoot((DotNotationNode)this.getModel().getRoot(), item), item);
        if (!this.m_Items.contains(item)) {
            this.m_Items.add(item);
            if (this.isSorted()) {
                Collections.sort(this.m_Items);
            }
        }
        if (added == null) {
            this.buildTree();
        }
    }

    protected List<String> applyItemFilter(List<String> items) {
        if (this.m_Filter == null || !this.m_Filter.isEnabled()) {
            return items;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            if (!this.m_Filter.filter(item)) continue;
            result.add(item);
        }
        return result;
    }

    public void setItems(List<String> items) {
        this.m_Items.clear();
        this.m_Items.addAll(items);
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public void setItems(String[] items) {
        this.m_Items.clear();
        for (String item : items) {
            this.m_Items.add(item);
        }
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public void setItems(BaseString[] items) {
        this.m_Items.clear();
        for (BaseString item : items) {
            this.m_Items.add(item.getValue());
        }
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public void addItems(List<String> items) {
        this.m_Items.addAll(items);
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public void addItems(String[] items) {
        this.m_Items.addAll(Arrays.asList(items));
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public void addItems(BaseString[] items) {
        for (BaseString item : items) {
            this.m_Items.add(item.getValue());
        }
        if (this.m_Sorted) {
            Collections.sort(this.m_Items);
        }
        this.buildTree();
    }

    public String getFirstItem() {
        if (this.m_Items.size() > 0) {
            return this.m_Items.get(0);
        }
        return null;
    }

    public void setSelectedItem(String item) {
        this.setSelectedItems(new String[]{item});
    }

    public void setSelectedItems(String[] items) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (String item : items) {
            DotNotationNode node = this.findItem(this.findRoot((DotNotationNode)this.getTreeModel().getRoot(), item), item);
            if (node == null) continue;
            paths.add(new TreePath(node.getPath()));
        }
        this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
    }

    public String getSelectedItem() {
        String result = null;
        if (this.getSelectionPath() != null) {
            DotNotationNode selected = (DotNotationNode)this.getSelectionPath().getLastPathComponent();
            result = selected.getItem();
        }
        return result;
    }

    public String[] getSelectedItems() {
        ArrayList<String> result = new ArrayList<String>();
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DotNotationNode selected = (DotNotationNode)path.getLastPathComponent();
                if (selected.getItem() == null) continue;
                result.add(selected.getItem());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setSearch(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Search = value;
        this.buildTree();
        this.expandAfterSearch();
    }

    protected void expandAfterSearch() {
        this.expandAll();
    }

    public String getSearch() {
        if (this.m_Search.length() == 0) {
            return null;
        }
        return this.m_Search;
    }

    public void addInfoNodeGenerator(AbstractInfoNodeGenerator generator) {
        if (!this.m_InfoNodeGenerators.contains(generator)) {
            this.m_InfoNodeGenerators.add(generator);
            this.buildTree();
        }
    }

    public void removeInfoNodeGenerator(AbstractInfoNodeGenerator generator) {
        if (this.m_InfoNodeGenerators.remove(generator)) {
            this.buildTree();
        }
    }

    public void setPopupMenuHandler(PopupMenuHandler value) {
        this.m_PopupMenuHandler = value;
    }

    public PopupMenuHandler getPopupMenuHandler() {
        return this.m_PopupMenuHandler;
    }

    public static void main(String[] args) {
        ArrayList<String> classes = new ArrayList<String>();
        classes.add("weka.classifiers.trees.J48");
        classes.add("weka.classifiers.rules.ZeroR");
        classes.add("dummy.classifiers.trees.MyJ48");
        final DotNotationTree tree = new DotNotationTree();
        tree.setSorted(true);
        tree.setItems(classes);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                System.out.println(tree.getSelectedItem());
            }
        });
        final JTextField search = new JTextField();
        search.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                tree.setSearch(search.getText());
            }
        });
        JFrame frame = new JFrame("DotNotation tree");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)new BaseScrollPane(tree), "Center");
        frame.getContentPane().add((Component)search, "South");
        frame.setSize(640, 480);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        tree.setSelectionMode(4);
        tree.setSelectedItems(new String[]{"weka.classifiers.rules.ZeroR", "dummy.classifiers.trees.MyJ48"});
    }
}

