/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.json;

import adams.core.JsonSupporter;
import adams.gui.core.BaseTree;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.json.JsonNode;
import adams.gui.core.json.JsonRenderer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class JsonTree
extends BaseTree
implements JsonSupporter {
    private static final long serialVersionUID = -3618290386432060103L;
    protected JSONAware m_JSON;
    protected boolean m_SortKeys;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_JSON = null;
        this.m_SortKeys = false;
        this.getSelectionModel().setSelectionMode(1);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JsonTree.this.isEnabled() && MouseUtils.isRightClick(e)) {
                    e.consume();
                    JsonTree.this.showNodePopupMenu(e);
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.setCellRenderer(new JsonRenderer());
        this.buildTree();
    }

    protected void buildTree(JsonNode parent, JSONObject obj) {
        ArrayList keys = new ArrayList(obj.keySet());
        if (this.m_SortKeys) {
            Collections.sort(keys);
        }
        for (Object key : keys) {
            Object value = obj.get(key);
            JsonNode child = new JsonNode("" + key, value);
            parent.add(child);
            if (value instanceof JSONObject) {
                this.buildTree(child, (JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.buildTree(child, (JSONArray)value);
        }
    }

    protected void buildTree(JsonNode parent, JSONArray obj) {
        int i = 0;
        for (Object value : obj) {
            JsonNode child = new JsonNode("" + ++i, value);
            parent.add(child);
            if (value instanceof JSONObject) {
                this.buildTree(child, (JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            this.buildTree(child, (JSONArray)value);
        }
    }

    protected JsonNode buildTree(JsonNode parent, Object obj) {
        if (parent == null) {
            parent = new JsonNode("json", obj);
            this.buildTree(parent, obj);
        } else if (obj instanceof JSONObject) {
            this.buildTree(parent, (JSONObject)obj);
        } else if (obj instanceof JSONArray) {
            this.buildTree(parent, (JSONArray)obj);
        } else {
            JsonNode child = new JsonNode("" + obj, obj);
            parent.add(child);
        }
        JsonNode result = parent;
        return result;
    }

    protected void buildTree() {
        JsonNode root = this.m_JSON == null ? new JsonNode("empty", null) : this.buildTree(null, this.m_JSON);
        this.setModel(new DefaultTreeModel(root));
        this.expand(root);
    }

    protected void showNodePopupMenu(MouseEvent e) {
        JPopupMenu menu = null;
        int selRow = this.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.getPathForLocation(e.getX(), e.getY());
        if (selPath == null) {
            return;
        }
        final JsonNode selNode = (JsonNode)selPath.getLastPathComponent();
        if (selRow > -1) {
            menu = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.setEnabled(selNode.hasValue());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUIHelper.copyToClipboard(selNode.toTransferable());
                }
            });
            menu.add(menuitem);
        }
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void setJSON(JSONAware value) {
        this.m_JSON = value;
        this.buildTree();
    }

    @Override
    public JSONAware getJSON() {
        return this.m_JSON;
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.buildTree();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }
}

