/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.json;

import adams.core.JsonSupporter;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.GUIHelper;
import adams.gui.core.json.JsonNode;
import adams.gui.core.json.JsonTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import net.minidev.json.JSONAware;

public class JsonTreeWithPreview
extends BasePanel
implements JsonSupporter {
    private static final long serialVersionUID = 7380711856972284896L;
    protected JsonTree m_Tree;
    protected BaseTextArea m_TextArea;
    protected JButton m_ButtonCopy;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Tree = new JsonTree();
        this.m_Tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JsonTreeWithPreview.this.updateButtons();
                JsonNode node = (JsonNode)e.getPath().getLastPathComponent();
                if (node.hasValue()) {
                    JsonTreeWithPreview.this.m_TextArea.setText("" + node.getValue());
                } else {
                    JsonTreeWithPreview.this.m_TextArea.setText("");
                }
            }
        });
        this.add((Component)new BaseScrollPane(this.m_Tree), "Center");
        JPanel panelPreview = new JPanel(new BorderLayout());
        this.add((Component)panelPreview, "South");
        this.m_TextArea = new BaseTextArea();
        this.m_TextArea.setEditable(false);
        this.m_TextArea.setLineWrap(true);
        this.m_TextArea.setWrapStyleWord(true);
        this.m_TextArea.setPreferredSize(new Dimension(100, 100));
        this.m_TextArea.setFont(GUIHelper.getMonospacedFont());
        panelPreview.add((Component)new BaseScrollPane(this.m_TextArea), "Center");
        JPanel panelButtons = new JPanel(new BorderLayout());
        panelPreview.add((Component)panelButtons, "East");
        this.m_ButtonCopy = new JButton(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(JsonTreeWithPreview.this.m_TextArea.getText());
            }
        });
        panelButtons.add((Component)this.m_ButtonCopy, "North");
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    public JsonTree getTree() {
        return this.m_Tree;
    }

    public BaseTextArea getTextArea() {
        return this.m_TextArea;
    }

    @Override
    public void setJSON(JSONAware value) {
        this.m_Tree.setJSON(value);
    }

    @Override
    public JSONAware getJSON() {
        return this.m_Tree.getJSON();
    }

    protected void updateButtons() {
        this.m_ButtonCopy.setEnabled(this.m_Tree.getSelectionCount() > 0);
    }

    public void setSortKeys(boolean value) {
        this.m_Tree.setSortKeys(value);
    }

    public boolean getSortKeys() {
        return this.m_Tree.getSortKeys();
    }
}

