/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.menu;

import adams.core.ByteFormat;
import adams.data.statistics.InformativeStatistic;
import adams.flow.core.ActorStatistic;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.menu.AbstractFlowEditorMenuItemAction;
import adams.gui.visualization.statistics.InformativeStatisticFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class FileProperties
extends AbstractFlowEditorMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;

    @Override
    protected String getTitle() {
        return "Properties...";
    }

    protected void showStatistics() {
        ActorStatistic stats = ((FlowEditorPanel)this.m_State).getCurrentTree().getSelectedNode() != null ? new ActorStatistic(((FlowEditorPanel)this.m_State).getCurrentTree().getSelectedNode().getFullActor()) : (((FlowEditorPanel)this.m_State).getCurrentFlow() != null ? new ActorStatistic(((FlowEditorPanel)this.m_State).getCurrentFlow()) : new ActorStatistic(((FlowEditorPanel)this.m_State).getCurrentFlow()));
        Vector<InformativeStatistic> statsList = new Vector<InformativeStatistic>();
        statsList.add(stats);
        InformativeStatisticFactory.Dialog dialog = this.getParentDialog() != null ? InformativeStatisticFactory.getDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : InformativeStatisticFactory.getDialog(this.getParentFrame(), true);
        dialog.setStatistics(statsList);
        dialog.setTitle("Actor statistics");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this.m_State);
        dialog.setVisible(true);
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        String file = ((FlowEditorPanel)this.m_State).getCurrentFile() != null ? ((FlowEditorPanel)this.m_State).getCurrentFile().toString() : "N/A";
        String size = ((FlowEditorPanel)this.m_State).getCurrentFile() != null && !((FlowEditorPanel)this.m_State).isModified() ? ByteFormat.toKiloBytes(((FlowEditorPanel)this.m_State).getCurrentFile().length(), 1) : "N/A";
        JButton buttonStats = new JButton("Display", GUIHelper.getIcon("statistics.png"));
        buttonStats.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileProperties.this.showStatistics();
            }
        });
        ParameterPanel params = new ParameterPanel();
        final JTextField textFile = new JTextField(file, 20);
        textFile.setEditable(false);
        textFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    e.consume();
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
                    menuitem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            GUIHelper.copyToClipboard(textFile.getText());
                        }
                    });
                    menu.add(menuitem);
                    menu.show(textFile, e.getX(), e.getY());
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        params.addParameter("File", textFile);
        JTextField textSize = new JTextField(size, 7);
        textSize.setEditable(false);
        params.addParameter("Size", textSize);
        params.addParameter("Statistics", buttonStats);
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog()) : new ApprovalDialog(this.getParentFrame());
        dialog.setTitle("Properties");
        dialog.setCancelVisible(false);
        dialog.setApproveVisible(true);
        dialog.setDiscardVisible(false);
        dialog.getContentPane().add((Component)params, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this.m_State);
        dialog.setVisible(true);
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((FlowEditorPanel)this.m_State).hasCurrentPanel());
    }
}

