/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.core.option.HtmlParametersProducer;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BrowserHelper;
import adams.gui.core.GUIHelper;
import adams.gui.flow.tab.AbstractEditorTab;
import adams.gui.flow.tab.SelectionAwareEditorTab;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.tree.TreePath;

public class ActorParametersTab
extends AbstractEditorTab
implements SelectionAwareEditorTab {
    private static final long serialVersionUID = 3860012648562358118L;
    public static final String DEFAULT_TEXT = "<html><center><b>No actor selected</b></center></html>";
    protected JEditorPane m_TextArea;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TextArea = new JEditorPane();
        this.m_TextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_TextArea.setEditable(false);
        this.m_TextArea.setFont(GUIHelper.getMonospacedFont());
        this.m_TextArea.setAutoscrolls(true);
        this.m_TextArea.setContentType("text/html");
        this.m_TextArea.setText(DEFAULT_TEXT);
        this.m_TextArea.addHyperlinkListener(new BrowserHelper.DefaultHyperlinkListener());
        this.add((Component)new BaseScrollPane(this.m_TextArea), "Center");
    }

    @Override
    public String getTitle() {
        return "Parameters";
    }

    @Override
    public void actorSelectionChanged(TreePath[] paths, AbstractActor[] actors) {
        if (actors.length != 1) {
            this.m_TextArea.setText(DEFAULT_TEXT);
            return;
        }
        HtmlParametersProducer producer = new HtmlParametersProducer();
        producer.produce(actors[0]);
        this.m_TextArea.setText(producer.toString());
        this.m_TextArea.setCaretPosition(0);
    }
}

