/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.core.ClassLister;
import adams.core.Utils;
import adams.core.option.NestedConsumer;
import adams.core.option.NestedProducer;
import adams.flow.control.Breakpoint;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorExecution;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.ActorPath;
import adams.flow.core.ActorUtils;
import adams.flow.core.FixedNameActorHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.GraphicalOutputProducingProcessor;
import adams.flow.processor.ModifyingProcessor;
import adams.flow.processor.RemoveDisabledActors;
import adams.flow.template.AbstractActorTemplate;
import adams.gui.core.BaseDialog;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.ConsolePanel;
import adams.gui.core.DragAndDropTree;
import adams.gui.core.DragAndDropTreeNodeCollection;
import adams.gui.core.ErrorMessagePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import adams.gui.core.dotnotationtree.AbstractItemFilter;
import adams.gui.event.ActorChangeEvent;
import adams.gui.event.ActorChangeListener;
import adams.gui.event.NodeDroppedEvent;
import adams.gui.event.NodeDroppedListener;
import adams.gui.flow.FlowEditorPanel;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tree.ActorSuggestion;
import adams.gui.flow.tree.CellEditor;
import adams.gui.flow.tree.ClipboardActorContainer;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.Renderer;
import adams.gui.flow.tree.SelectionModel;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.TreeModel;
import adams.gui.flow.tree.TreeNodeCollection;
import adams.gui.flow.tree.menu.EditActor;
import adams.gui.flow.tree.menu.TreePopupAction;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.classtree.ActorClassTreeFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class Tree
extends DragAndDropTree {
    private static final long serialVersionUID = -6052602093735801950L;
    protected Tree m_Self;
    protected FlowPanel m_Owner;
    protected HashSet<ActorChangeListener> m_ActorChangeListeners;
    protected boolean m_Modified;
    protected File m_File;
    protected Node m_LastSearchNode;
    protected String m_LastSearchString;
    protected String m_ActorNameColor;
    protected String m_ActorNameSize;
    protected String m_QuickInfoColor;
    protected String m_QuickInfoSize;
    protected String m_AnnotationsColor;
    protected String m_AnnotationsSize;
    protected String m_InputOutputColor;
    protected String m_InputOutputSize;
    protected String m_PlaceholdersColor;
    protected String m_PlaceholdersSize;
    protected String m_VariableHighlightBackground;
    protected String m_BookmarkHighlightBackground;
    protected boolean m_ShowQuickInfo;
    protected boolean m_ShowAnnotations;
    protected boolean m_ShowInputOutput;
    protected String[] m_InputOutputPrefixes;
    protected GenericObjectEditorDialog m_TemplateDialog;
    protected boolean m_StateUsesNested;
    protected Node m_CurrentEditingNode;
    protected Node m_CurrentEditingParent;
    protected AbstractActorTemplate m_LastTemplate;
    protected InsertPosition m_LastTemplateInsertPosition;
    protected boolean m_IgnoreNameChanges;
    protected List<TreePopupAction> m_Shortcuts;
    protected GenericObjectEditorDialog m_DialogProcessActors;
    protected boolean m_RecordAdd;

    public Tree(FlowPanel owner) {
        this(owner, null);
    }

    public Tree(FlowPanel owner, AbstractActor root) {
        this.m_Owner = owner;
        this.buildTree(root);
    }

    @Override
    protected void initialize() {
        String[] classes;
        super.initialize();
        this.m_Self = this;
        this.m_Modified = false;
        this.m_ActorChangeListeners = new HashSet();
        this.m_LastSearchString = "";
        this.m_LastSearchNode = null;
        this.m_ShowQuickInfo = true;
        this.m_ShowAnnotations = true;
        this.m_ShowInputOutput = false;
        this.m_ActorNameColor = "black";
        this.m_ActorNameSize = "3";
        this.m_QuickInfoColor = "#008800";
        this.m_QuickInfoSize = "-2";
        this.m_AnnotationsColor = "blue";
        this.m_AnnotationsSize = "-2";
        this.m_PlaceholdersColor = "navy";
        this.m_PlaceholdersSize = "-2";
        this.m_InputOutputColor = "grey";
        this.m_InputOutputSize = "-2";
        this.m_VariableHighlightBackground = "#FFDD88";
        this.m_BookmarkHighlightBackground = "#FFDD00";
        this.m_StateUsesNested = true;
        this.m_InputOutputPrefixes = new String[0];
        this.m_CurrentEditingNode = null;
        this.m_CurrentEditingParent = null;
        this.m_File = null;
        this.m_LastTemplate = null;
        this.m_IgnoreNameChanges = false;
        this.m_RecordAdd = false;
        this.putClientProperty("JTree.lineStyle", "None");
        this.setLargeModel(true);
        this.setSelectionModel(new SelectionModel());
        this.setCellRenderer(new Renderer());
        this.setCellEditor(new CellEditor(this, (Renderer)this.getCellRenderer()));
        this.setShowsRootHandles(true);
        this.setToggleClickCount(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (Tree.this.m_Self.isEnabled() && MouseUtils.isRightClick(e)) {
                    e.consume();
                    Tree.this.showNodePopupMenu(e);
                } else if (Tree.this.m_Self.isEnabled() && MouseUtils.isDoubleClick(e)) {
                    e.consume();
                    StateContainer state = Tree.this.getTreeState(e);
                    if (state == null) {
                        return;
                    }
                    EditActor action = new EditActor();
                    action.update(Tree.this.getTreeState(e));
                    action.actionPerformed(null);
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.m_Shortcuts = new ArrayList<TreePopupAction>();
        for (String cls : classes = ClassLister.getSingleton().getClassnames(TreePopupAction.class)) {
            try {
                TreePopupAction action = (TreePopupAction)Class.forName(cls).newInstance();
                if (!action.hasAccelerator()) continue;
                this.m_Shortcuts.add(action);
            }
            catch (Exception e) {
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Failed to instantiate action '" + cls + "':\n" + Utils.throwableToString(e));
            }
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath path = Tree.this.getSelectionPath();
                TreePath[] paths = Tree.this.getSelectionPaths();
                if (path != null) {
                    StateContainer state = Tree.this.getTreeState(paths, TreeHelper.pathToNode(path));
                    KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                    for (TreePopupAction action : Tree.this.m_Shortcuts) {
                        action.update(state);
                        if (!action.keyStrokeApplies(ks) || !action.isEnabled()) continue;
                        action.actionPerformed(null);
                        e.consume();
                        break;
                    }
                }
            }
        });
        this.addNodeDroppedListener(new NodeDroppedListener(){

            @Override
            public void nodeDropped(NodeDroppedEvent e) {
                BaseTreeNode[] tnodes = e.getNodes();
                ArrayList nodes = new ArrayList();
                if (e.getNotificationTime() == NodeDroppedEvent.NotificationTime.FINISHED) {
                    for (BaseTreeNode node : tnodes) {
                        if (!(node instanceof Node) || !Tree.this.updateActorName((Node)node)) continue;
                        Tree.this.nodeStructureChanged((Node)node);
                    }
                }
                if (e.getNotificationTime() == NodeDroppedEvent.NotificationTime.BEFORE) {
                    if (nodes.size() == 1) {
                        Tree.this.addUndoPoint("Drag'n'Drop of actor '" + ((Node)nodes.get(0)).getActor().getName() + "'");
                    } else {
                        Tree.this.addUndoPoint("Drag'n'Drop of " + nodes.size() + " actors");
                    }
                } else {
                    Tree.this.setModified(true);
                    Tree.this.notifyActorChangeListeners(new ActorChangeEvent(Tree.this.m_Self, nodes.toArray(new Node[nodes.size()]), ActorChangeEvent.Type.MODIFY));
                }
            }
        });
    }

    @Override
    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (!(selectionModel instanceof SelectionModel)) {
            throw new IllegalArgumentException("Only " + SelectionModel.class.getName() + " models are allowed");
        }
        super.setSelectionModel(selectionModel);
    }

    public void buildTree(AbstractActor root) {
        DefaultTreeModel model;
        TreeModel modelOld = null;
        if (this.getModel() instanceof TreeModel) {
            modelOld = (TreeModel)this.getModel();
        }
        if (root == null) {
            model = new DefaultTreeModel(null);
        } else {
            Node rootNode = this.buildTree(null, root, true);
            model = new DefaultTreeModel(rootNode);
        }
        this.setModel(model);
        if (model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
        if (modelOld != null) {
            modelOld.destroy();
        }
    }

    public Node buildTree(Node parent, AbstractActor actor, boolean append) {
        return this.buildTree(parent, new AbstractActor[]{actor}, append)[0];
    }

    protected Node[] buildTree(Node parent, AbstractActor[] actors, boolean append) {
        Node[] result = new Node[actors.length];
        for (int n = 0; n < actors.length; ++n) {
            result[n] = new Node(this, actors[n]);
            if (parent != null && append) {
                parent.add(result[n]);
            }
            if (!(actors[n] instanceof ActorHandler)) continue;
            for (int i = 0; i < ((ActorHandler)((Object)actors[n])).size(); ++i) {
                this.buildTree(result[n], ((ActorHandler)((Object)actors[n])).get(i), true);
            }
        }
        return result;
    }

    public boolean updateActorName(Node node) {
        boolean result = false;
        Node parent = (Node)node.getParent();
        if (parent != null) {
            if (parent.getActor() instanceof FixedNameActorHandler) {
                int i = parent.getIndex(node);
                AbstractActor actor = node.getActor();
                String name = ((FixedNameActorHandler)((Object)parent.getActor())).getFixedName(i);
                if (!actor.getName().equals(name)) {
                    actor.setName(name);
                    node.setActor(actor);
                    result = true;
                }
            } else if (parent.getActor() instanceof ActorHandler) {
                AbstractActor actor = node.getActor();
                HashSet<String> names = new HashSet<String>();
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (parent.getChildAt(i) == node) continue;
                    names.add(((Node)parent.getChildAt(i)).getActor().getName());
                }
                result = ActorUtils.uniqueName(actor, names);
                if (result) {
                    node.setActor(actor);
                }
            }
        }
        return result;
    }

    public FlowPanel getOwner() {
        return this.m_Owner;
    }

    public FlowEditorPanel getEditor() {
        return this.m_Owner.getEditor();
    }

    public void setActorNameColor(String value) {
        this.m_ActorNameColor = value;
    }

    public String getActorNameColor() {
        return this.m_ActorNameColor;
    }

    public void setActorNameSize(String value) {
        this.m_ActorNameSize = value;
    }

    public String getActorNameSize() {
        return this.m_ActorNameSize;
    }

    public void setAnnotationsColor(String value) {
        this.m_AnnotationsColor = value;
    }

    public String getAnnotationsColor() {
        return this.m_AnnotationsColor;
    }

    public void setAnnotationsSize(String value) {
        this.m_AnnotationsSize = value;
    }

    public String getAnnotationsSize() {
        return this.m_AnnotationsSize;
    }

    public void setQuickInfoColor(String value) {
        this.m_QuickInfoColor = value;
    }

    public String getQuickInfoColor() {
        return this.m_QuickInfoColor;
    }

    public void setQuickInfoSize(String value) {
        this.m_QuickInfoSize = value;
    }

    public String getQuickInfoSize() {
        return this.m_QuickInfoSize;
    }

    public void setInputOutputColor(String value) {
        this.m_InputOutputColor = value;
    }

    public String getInputOutputColor() {
        return this.m_InputOutputColor;
    }

    public void setInputOutputSize(String value) {
        this.m_InputOutputSize = value;
    }

    public String getInputOutputSize() {
        return this.m_InputOutputSize;
    }

    public void setPlaceholdersColor(String value) {
        this.m_PlaceholdersColor = value;
    }

    public String getPlaceholdersColor() {
        return this.m_PlaceholdersColor;
    }

    public void setPlaceholdersSize(String value) {
        this.m_PlaceholdersSize = value;
    }

    public String getPlaceholdersSize() {
        return this.m_PlaceholdersSize;
    }

    public void setVariableHighlightBackground(String value) {
        this.m_VariableHighlightBackground = value;
    }

    public String getVariableHighlightBackground() {
        return this.m_VariableHighlightBackground;
    }

    public void setBookmarkHighlightBackground(String value) {
        this.m_BookmarkHighlightBackground = value;
    }

    public String getBookmarkHighlightBackground() {
        return this.m_BookmarkHighlightBackground;
    }

    public void setStateUsesNested(boolean value) {
        this.m_StateUsesNested = value;
    }

    public boolean getStateUsesNested() {
        return this.m_StateUsesNested;
    }

    public void setIgnoreNameChanges(boolean value) {
        this.m_IgnoreNameChanges = value;
    }

    public boolean getIgnoreNameChanges() {
        return this.m_IgnoreNameChanges;
    }

    public void setRecordAdd(boolean value) {
        this.m_RecordAdd = value;
    }

    public boolean getRecordAdd() {
        return this.m_RecordAdd;
    }

    public void nodeStructureChanged(Node node) {
        if (node != null) {
            node.invalidateRendering();
        }
        this.redraw(node);
    }

    public AbstractActor getActorFromClipboard() {
        AbstractActor result = null;
        try {
            if (GUIHelper.canPasteStringFromClipboard()) {
                NestedConsumer consumer = new NestedConsumer();
                consumer.setQuiet(true);
                result = (AbstractActor)consumer.fromString(GUIHelper.pasteSetupFromClipboard());
                consumer.cleanUp();
            }
        }
        catch (Exception ex) {
            result = null;
        }
        return result;
    }

    protected boolean canPasteActor() {
        return this.getActorFromClipboard() != null;
    }

    protected boolean canRemoveActors(TreePath[] paths) {
        Node[] nodes;
        boolean result = paths.length > 0;
        for (Node node : nodes = TreeHelper.pathsToNodes(paths)) {
            Node parent = (Node)node.getParent();
            boolean bl = result = parent != null && parent.getActor() instanceof MutableActorHandler;
            if (!result) break;
        }
        return result;
    }

    protected StateContainer getTreeState(MouseEvent e) {
        if (this.getPathForLocation(e.getX(), e.getY()) == null) {
            return null;
        }
        return this.getTreeState(this.getSelectionPaths(), (Node)this.getPathForLocation(e.getX(), e.getY()).getLastPathComponent());
    }

    protected StateContainer getTreeState(TreePath[] paths, Node currNode) {
        StateContainer result = new StateContainer();
        result.tree = this;
        result.selPaths = paths;
        result.numSel = result.selPaths == null ? 0 : result.selPaths.length;
        result.nodeAtMouseLoc = currNode;
        result.isSingleSel = result.numSel == 1;
        result.selPath = result.isSingleSel ? result.selPaths[0] : null;
        if (result.numSel > 0) {
            result.selNode = TreeHelper.pathToNode(result.selPaths[0]);
            result.parent = (Node)result.selNode.getParent();
        } else {
            result.selNode = null;
            result.parent = null;
        }
        result.editable = this.isEditable() && result.nodeAtMouseLoc.isEditable();
        result.canRemove = result.editable && result.numSel > 0 && this.canRemoveActors(result.selPaths);
        result.canPaste = result.editable && result.numSel > 0 && this.canPasteActor();
        result.isMutable = result.editable && result.selNode != null && result.selNode.getActor() instanceof MutableActorHandler;
        result.isParentMutable = result.editable && result.parent != null && result.parent.getActor() instanceof MutableActorHandler;
        result.lastTemplate = this.m_LastTemplate;
        result.lastTemplateInsertPosition = this.m_LastTemplateInsertPosition;
        result.runningFlow = null;
        if (this.getOwner().getRunningFlow() instanceof Flow) {
            result.runningFlow = (Flow)this.getOwner().getRunningFlow();
        }
        return result;
    }

    public void showNodePopupMenu(MouseEvent e) {
        JPopupMenu menu = this.createNodePopupMenu(e);
        if (menu != null) {
            menu.show(this, e.getX(), e.getY());
        }
    }

    public JPopupMenu createNodePopupMenu(MouseEvent e) {
        String[] items;
        StateContainer state = this.getTreeState(e);
        if (state == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        for (String item : items = FlowEditorPanel.getPropertiesEditor().getProperty("Tree.PopupMenu", "").replace(" ", "").split(",")) {
            if (item.trim().length() == 0) continue;
            if (item.equals("-")) {
                menu.addSeparator();
                continue;
            }
            try {
                TreePopupAction action = (TreePopupAction)Class.forName(item).newInstance();
                action.update(state);
                menu.add(action.getMenuItem());
            }
            catch (Exception ex) {
                ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Failed to instantiate tree popup menu item '" + item + "':\n" + Utils.throwableToString(ex));
            }
        }
        return menu;
    }

    public void addUndoPoint(String comment) {
        if (this.getOwner() != null) {
            this.getOwner().addUndoPoint("Saving undo data...", comment);
        }
    }

    public void toggleEnabledState(TreePath[] paths) {
        Node[] nodes = TreeHelper.pathsToNodes(paths);
        if (nodes.length == 1) {
            this.addUndoPoint("Toggling enabled state of " + nodes[0].getFullName());
        } else {
            this.addUndoPoint("Toggling enabled state of " + nodes.length + " actors");
        }
        for (int i = 0; i < nodes.length; ++i) {
            AbstractActor actor;
            actor.setSkip(!(actor = nodes[i].getActor()).getSkip());
            nodes[i].setActor(actor);
            ((DefaultTreeModel)this.getModel()).nodeChanged(nodes[i]);
        }
        this.setModified(true);
        if (nodes.length == 1) {
            this.notifyActorChangeListeners(new ActorChangeEvent(this.m_Self, nodes[0], ActorChangeEvent.Type.MODIFY));
        } else {
            this.notifyActorChangeListeners(new ActorChangeEvent(this.m_Self, nodes, ActorChangeEvent.Type.MODIFY_RANGE));
        }
    }

    protected AbstractActor[] suggestActors(TreePath path, InsertPosition position) {
        AbstractActor[] result = null;
        if (result == null) {
            int pos;
            Node parentNode;
            if (position == InsertPosition.BENEATH) {
                parentNode = TreeHelper.pathToNode(path);
                pos = parentNode.getChildCount();
            } else {
                Node node = TreeHelper.pathToNode(path);
                parentNode = (Node)node.getParent();
                pos = parentNode.getIndex(node);
                if (position == InsertPosition.AFTER) {
                    ++pos;
                }
            }
            AbstractActor parent = parentNode.getActor();
            AbstractActor[] actors = new AbstractActor[parentNode.getChildCount()];
            for (int i = 0; i < actors.length; ++i) {
                actors[i] = ((Node)parentNode.getChildAt(i)).getActor();
            }
            AbstractActor[] suggestions = ActorSuggestion.getSingleton().suggest(parent, pos, actors);
            if (suggestions.length > 0) {
                result = suggestions;
            }
        }
        return result;
    }

    public boolean checkForStandalones(AbstractActor actor, Node parent) {
        return this.checkForStandalones(new AbstractActor[]{actor}, parent);
    }

    public boolean checkForStandalones(AbstractActor[] actors, Node parent) {
        for (AbstractActor actor : actors) {
            if (!ActorUtils.isStandalone(actor) || parent == null || !(parent.getActor() instanceof ActorHandler) || ((ActorHandler)((Object)parent.getActor())).getActorHandlerInfo().canContainStandalones()) continue;
            GUIHelper.showErrorMessage(this.m_Self, "Actor '" + parent.getFullName() + "' cannot contain standalones!");
            return false;
        }
        return true;
    }

    protected AbstractActor getNearestActor(Node parent, int startIndex, boolean forward) {
        AbstractActor result;
        block6: {
            result = null;
            if (parent.getChildCount() <= 0) break block6;
            int index = startIndex;
            if (forward) {
                ++index;
                while (index < parent.getChildCount()) {
                    Node child = (Node)parent.getChildAt(index);
                    AbstractActor actor = child.getActor();
                    if (actor.getSkip()) {
                        ++index;
                        continue;
                    }
                    result = actor;
                    break;
                }
            } else {
                --index;
                while (index >= 0) {
                    Node child = (Node)parent.getChildAt(index);
                    AbstractActor actor = child.getActor();
                    if (actor.getSkip()) {
                        --index;
                        continue;
                    }
                    result = actor;
                    break;
                }
            }
        }
        return result;
    }

    public AbstractItemFilter configureFilter(TreePath path, InsertPosition position) {
        AbstractActor parent;
        ActorClassTreeFilter result = new ActorClassTreeFilter();
        AbstractActor after = null;
        AbstractActor before = null;
        Node parentNode = null;
        ActorHandlerInfo handlerInfo = null;
        if (position == null) {
            Node node = TreeHelper.pathToNode(path);
            parentNode = (Node)node.getParent();
            if (parentNode != null && (parent = parentNode.getActor()) instanceof MutableActorHandler && (handlerInfo = ((MutableActorHandler)((Object)parent)).getActorHandlerInfo()).getActorExecution() == ActorExecution.SEQUENTIAL) {
                int index = parentNode.getIndex(node);
                before = this.getNearestActor(parentNode, index, false);
                after = this.getNearestActor(parentNode, index, true);
            }
        } else if (position == InsertPosition.BENEATH) {
            parentNode = TreeHelper.pathToNode(path);
            before = this.getNearestActor(parentNode, parentNode.getChildCount(), false);
        } else if (position == InsertPosition.HERE) {
            Node node = TreeHelper.pathToNode(path);
            parentNode = (Node)node.getParent();
            int index = parentNode.getIndex(node);
            before = this.getNearestActor(parentNode, index, false);
            after = node.getActor();
            if (after.getSkip()) {
                after = this.getNearestActor(parentNode, index, true);
            }
        } else if (position == InsertPosition.AFTER) {
            Node node = TreeHelper.pathToNode(path);
            parentNode = (Node)node.getParent();
            int index = parentNode.getIndex(node);
            after = this.getNearestActor(parentNode, index, true);
            before = node.getActor();
            if (before.getSkip()) {
                before = this.getNearestActor(parentNode, index, false);
            }
        }
        if (handlerInfo == null && parentNode != null && (parent = parentNode.getActor()) instanceof ActorHandler) {
            handlerInfo = ((ActorHandler)((Object)parent)).getActorHandlerInfo();
        }
        if (before != null && !(before instanceof OutputProducer)) {
            before = null;
        }
        if (after != null && !(after instanceof InputConsumer)) {
            after = null;
        }
        if (handlerInfo != null && handlerInfo.getActorExecution() != ActorExecution.SEQUENTIAL) {
            before = null;
            after = null;
        }
        if (before != null) {
            result.setAccepts(((OutputProducer)((Object)before)).generates());
        } else {
            result.setAccepts(null);
        }
        if (after != null) {
            result.setGenerates(((InputConsumer)((Object)after)).accepts());
        } else {
            result.setGenerates(null);
        }
        result.setStandalonesAllowed(false);
        if (handlerInfo != null && handlerInfo.canContainStandalones() && (before == null || before != null && ActorUtils.isStandalone(before))) {
            result.setStandalonesAllowed(true);
        }
        result.setSourcesAllowed(false);
        if (handlerInfo != null && handlerInfo.canContainSource() && (before == null || before != null && ActorUtils.isStandalone(before))) {
            result.setSourcesAllowed(true);
        }
        if (handlerInfo != null && handlerInfo.hasRestrictions()) {
            result.setRestrictions(handlerInfo.getRestrictions());
        }
        return result;
    }

    public void addActor(TreePath path, AbstractActor actor, InsertPosition position) {
        this.addActor(path, actor, position, false);
    }

    public void addActor(TreePath path, AbstractActor actor, InsertPosition position, boolean record) {
        if (actor == null) {
            Node node = TreeHelper.pathToNode(path);
            this.m_CurrentEditingParent = position == InsertPosition.BENEATH ? node : (Node)node.getParent();
            GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this);
            if (position == InsertPosition.HERE) {
                dialog.setTitle("Add here...");
            } else if (position == InsertPosition.AFTER) {
                dialog.setTitle("Add after...");
            } else if (position == InsertPosition.BENEATH) {
                dialog.setTitle("Add beneath...");
            }
            Object[] actors = this.suggestActors(path, position);
            dialog.getGOEEditor().setCanChangeClassInDialog(true);
            dialog.getGOEEditor().setClassType(AbstractActor.class);
            dialog.getGOEEditor().setFilter(this.configureFilter(path, position));
            dialog.setProposedClasses(actors);
            if (actors != null) {
                dialog.setCurrent(actors[0]);
            } else {
                dialog.setCurrent(null);
            }
            dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            dialog.setVisible(true);
            this.m_CurrentEditingParent = null;
            if (dialog.getResult() == 0) {
                this.addActor(path, (AbstractActor)dialog.getEditor().getValue(), position, record);
            }
        } else {
            Node node;
            if (position == InsertPosition.BENEATH) {
                Node[] children;
                node = TreeHelper.pathToNode(path);
                AbstractActor[] actors = actor instanceof ClipboardActorContainer ? ((ClipboardActorContainer)actor).getActors() : new AbstractActor[]{actor};
                if (actors.length < 1) {
                    return;
                }
                if (!this.checkForStandalones(actors, node)) {
                    return;
                }
                String txt = actors.length == 1 ? "'" + actors[0].getName() + "'" : actors.length + " actors";
                this.addUndoPoint("Adding " + txt + " to '" + node.getFullName() + "'");
                List<TreePath> exp = this.getExpandedNodes();
                for (Node child : children = this.buildTree(node, actors, true)) {
                    this.updateActorName(child);
                }
                this.nodeStructureChanged(node);
                this.setExpandedNodes(exp);
                this.expand(node);
                if (this.m_RecordAdd && actors.length == 1) {
                    ActorSuggestion.getSingleton().record(children[0], node, position);
                }
            } else {
                Node[] children;
                AbstractActor[] actors;
                node = TreeHelper.pathToNode(path);
                Node parent = (Node)node.getParent();
                int index = node.getParent().getIndex(node);
                if (position == InsertPosition.AFTER) {
                    ++index;
                }
                if ((actors = actor instanceof ClipboardActorContainer ? ((ClipboardActorContainer)actor).getActors() : new AbstractActor[]{actor}).length < 1) {
                    return;
                }
                if (!this.checkForStandalones(actors, parent)) {
                    return;
                }
                String txt = actors.length == 1 ? "'" + actors[0].getName() + "'" : actors.length + " actors";
                if (position == InsertPosition.AFTER) {
                    this.addUndoPoint("Adding " + txt + " after " + ((Node)parent.getChildAt(index - 1)).getFullName() + "'");
                } else {
                    this.addUndoPoint("Adding " + txt + " before " + ((Node)parent.getChildAt(index)).getFullName() + "'");
                }
                List<TreePath> exp = this.getExpandedNodes();
                for (Node child : children = this.buildTree(node, actors, false)) {
                    parent.insert(child, index);
                    this.updateActorName(child);
                    ++index;
                }
                this.nodeStructureChanged(parent);
                this.setExpandedNodes(exp);
                if (this.m_RecordAdd && actors.length == 1) {
                    ActorSuggestion.getSingleton().record(children[0], parent, position);
                }
            }
            this.setModified(true);
            this.notifyActorChangeListeners(new ActorChangeEvent(this.m_Self, node, ActorChangeEvent.Type.MODIFY));
        }
    }

    public void addActorChangeListener(ActorChangeListener l) {
        this.m_ActorChangeListeners.add(l);
    }

    public void removeActorChangeListener(ActorChangeListener l) {
        this.m_ActorChangeListeners.remove(l);
    }

    public void notifyActorChangeListeners(ActorChangeEvent e) {
        Iterator<ActorChangeListener> iter = this.m_ActorChangeListeners.iterator();
        while (iter.hasNext()) {
            iter.next().actorChanged(e);
        }
    }

    public void setActor(AbstractActor value) {
        this.buildTree(value);
    }

    public AbstractActor getActor() {
        return this.getActor(null);
    }

    public AbstractActor getActor(StringBuilder errors) {
        AbstractActor result = null;
        if (this.getModel().getRoot() != null) {
            result = ((Node)this.getModel().getRoot()).getFullActor(errors);
        }
        return result;
    }

    public AbstractActor getRootActor() {
        AbstractActor result = null;
        if (this.getModel().getRoot() != null) {
            result = ((Node)this.getModel().getRoot()).getActor();
        }
        return result;
    }

    public boolean isFlow() {
        if (this.getModel().getRoot() == null) {
            return false;
        }
        return ((Node)this.getModel().getRoot()).getActor() instanceof Flow;
    }

    public void setModified(boolean value) {
        this.m_Modified = value;
    }

    public boolean isModified() {
        return this.m_Modified;
    }

    public void setFile(File value) {
        this.m_File = value;
    }

    public File getFile() {
        return this.m_File;
    }

    @Override
    public int[] getSelectionRows() {
        int[] result = super.getSelectionRows();
        if (result == null) {
            result = new int[]{};
        } else {
            Arrays.sort(result);
        }
        return result;
    }

    @Override
    public TreePath[] getSelectionPaths() {
        int[] sel = this.getSelectionRows();
        TreePath[] result = new TreePath[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            result[i] = this.getPathForRow(sel[i]);
        }
        return result;
    }

    public Node getSelectedNode() {
        Node result = null;
        if (this.getSelectionPath() != null) {
            result = TreeHelper.pathToNode(this.getSelectionPath());
        }
        return result;
    }

    public AbstractActor getSelectedActor() {
        AbstractActor result = null;
        Node node = this.getSelectedNode();
        if (node != null) {
            result = node.getActor();
        }
        return result;
    }

    public AbstractActor[] getSelectedActors() {
        AbstractActor[] result = this.getSelectionPaths() != null ? TreeHelper.pathsToActors(this.getSelectionPaths()) : new AbstractActor[]{};
        return result;
    }

    public String getSelectedFullName() {
        String result = null;
        Node node = this.getSelectedNode();
        if (node != null) {
            result = node.getFullName();
        }
        return result;
    }

    protected Node locate(Node parent, ActorPath path) {
        Node child;
        Node result = null;
        int index = -1;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            child = (Node)parent.getChildAt(i);
            if (!child.getActor().getName().equals(path.getFirstPathComponent())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            child = (Node)parent.getChildAt(index);
            result = path.getPathCount() == 1 ? child : this.locate(child, path.getChildPath());
        } else {
            ConsolePanel.getSingleton().append(ConsolePanel.OutputType.ERROR, "Malformed path?");
        }
        return result;
    }

    public Node locate(String path) {
        Node result = null;
        ActorPath actorPath = new ActorPath(path);
        Node root = (Node)this.getModel().getRoot();
        if (actorPath.getFirstPathComponent().equals(root.getActor().getName())) {
            result = actorPath.getPathCount() == 1 ? root : this.locate(root, actorPath.getChildPath());
        }
        return result;
    }

    public void locateAndDisplay(String path) {
        Node node = this.locate(path);
        if (node != null) {
            TreePath tpath = this.getPath(node);
            this.setSelectionPath(tpath);
            this.scrollPathToVisible(tpath);
        }
    }

    public Node find(Node subtree, Node last, String search, boolean isRegExp) {
        Node current;
        Node result = null;
        if (!isRegExp) {
            search = search.toLowerCase();
        }
        if (subtree == null) {
            subtree = (Node)this.getModel().getRoot();
        }
        Enumeration<TreeNode> enm = subtree.preorderEnumeration();
        if (last != null) {
            while (enm.hasMoreElements() && (current = (Node)enm.nextElement()) != last) {
            }
        }
        while (enm.hasMoreElements()) {
            current = (Node)enm.nextElement();
            if (isRegExp) {
                if (!current.getActor().getName().toLowerCase().matches(search)) continue;
                result = current;
                break;
            }
            if (current.getActor().getName().toLowerCase().indexOf(search) <= -1) continue;
            result = current;
            break;
        }
        return result;
    }

    public TreePath getPath(Node node) {
        return new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(node));
    }

    public void find() {
        TreePath path = this.getSelectionPath();
        Node node = path != null ? TreeHelper.pathToNode(path) : null;
        String search = GUIHelper.showInputDialog(GUIHelper.getParentComponent(this), "Please enter the search string (" + (node == null ? "whole flow" : "below '" + node.getActor().getName() + "'") + "):", this.getLastSearchString());
        if (search == null) {
            return;
        }
        this.setLastSearchString(search);
        this.setLastSearchNode(this.find(node, null, this.getLastSearchString(), false));
        if (this.getLastSearchNode() == null) {
            GUIHelper.showErrorMessage(this.m_Self, "Search string '" + this.getLastSearchString() + "' not found!");
        } else {
            path = this.getPath(this.getLastSearchNode());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public void findNext() {
        this.setLastSearchNode(this.find(null, this.getLastSearchNode(), this.getLastSearchString(), false));
        if (this.getLastSearchNode() == null) {
            GUIHelper.showErrorMessage(this.m_Self, "Search string '" + this.getLastSearchString() + "' not found!");
        } else {
            TreePath path = this.getPath(this.getLastSearchNode());
            this.setSelectionPath(path);
            this.scrollPathToVisible(path);
        }
    }

    public void setLastSearchString(String value) {
        this.m_LastSearchString = value;
    }

    public String getLastSearchString() {
        return this.m_LastSearchString;
    }

    public void setLastSearchNode(Node value) {
        this.m_LastSearchNode = value;
    }

    public Node getLastSearchNode() {
        return this.m_LastSearchNode;
    }

    public void setShowQuickInfo(boolean value) {
        this.m_ShowQuickInfo = value;
        this.nodeStructureChanged((Node)this.getModel().getRoot());
    }

    public boolean getShowQuickInfo() {
        return this.m_ShowQuickInfo;
    }

    public void setShowAnnotations(boolean value) {
        this.m_ShowAnnotations = value;
        this.nodeStructureChanged((Node)this.getModel().getRoot());
    }

    public boolean getShowAnnotations() {
        return this.m_ShowAnnotations;
    }

    public void setShowInputOutput(boolean value) {
        this.m_ShowInputOutput = value;
        this.nodeStructureChanged((Node)this.getModel().getRoot());
    }

    public boolean getShowInputOutput() {
        return this.m_ShowInputOutput;
    }

    public void setInputOutputPrefixes(String[] value) {
        this.m_InputOutputPrefixes = (String[])value.clone();
    }

    public String[] getInputOutputPrefixes() {
        return this.m_InputOutputPrefixes;
    }

    public void setIconScaleFactor(double value) {
        if (value != ((Renderer)this.getCellRenderer()).getScaleFactor()) {
            this.setCellRenderer(new Renderer(value));
        }
    }

    public double getIconScaleFactor() {
        return ((Renderer)this.getCellRenderer()).getScaleFactor();
    }

    public void setState(Vector value) {
        AbstractActor actor;
        if (this.m_StateUsesNested) {
            if (value.get(0) != null) {
                NestedConsumer consumer = new NestedConsumer();
                consumer.setInput((ArrayList)value.get(0));
                actor = (AbstractActor)consumer.consume();
                consumer.cleanUp();
            } else {
                actor = null;
            }
        } else {
            actor = (AbstractActor)value.get(0);
        }
        boolean[] expanded = (boolean[])value.get(1);
        Boolean modified = (Boolean)value.get(2);
        File file = (File)value.get(3);
        this.setActor(actor);
        this.setExpandedState(expanded);
        this.setModified(modified);
        this.setFile(file);
    }

    public Vector getState() {
        Vector<Object> result = new Vector<Object>();
        AbstractActor actor = this.getActor();
        if (this.m_StateUsesNested) {
            if (actor == null) {
                result.add(null);
            } else {
                NestedProducer producer = new NestedProducer();
                producer.produce(actor);
                result.add(producer.getOutput());
                actor.destroy();
                producer.cleanUp();
            }
        } else {
            result.add(actor);
        }
        result.add(this.getExpandedState());
        result.add(this.isModified());
        result.add(this.getFile());
        return result;
    }

    @Override
    protected String getDropMenuActionCaption(DragAndDropTree.DropMenu action) {
        if (action == DragAndDropTree.DropMenu.ADD) {
            return "Add actor";
        }
        if (action == DragAndDropTree.DropMenu.MOVE) {
            return "Move actor";
        }
        return super.getDropMenuActionCaption(action);
    }

    @Override
    protected ImageIcon getDropMenuActionIcon(DragAndDropTree.DropMenu action) {
        if (action == DragAndDropTree.DropMenu.ADD) {
            return GUIHelper.getIcon("flow.gif");
        }
        if (action == DragAndDropTree.DropMenu.CANCEL) {
            return GUIHelper.getIcon("delete.gif");
        }
        return super.getDropMenuActionIcon(action);
    }

    @Override
    protected boolean isDragEnabled() {
        return true;
    }

    @Override
    protected boolean isDropEnabled() {
        return true;
    }

    protected boolean canStartDrag(BaseTreeNode source) {
        return source.getParent() != null && ((Node)source.getParent()).getActor() instanceof MutableActorHandler;
    }

    @Override
    protected boolean canDrop(Transferable source, TreeNode target, DragAndDropTree.DropPosition position) {
        boolean result = super.canDrop(source, target, position);
        if (result) {
            Node parent = (Node)target.getParent();
            if (position == DragAndDropTree.DropPosition.BENEATH) {
                result = ((Node)target).getActor() instanceof MutableActorHandler;
            } else if (position == DragAndDropTree.DropPosition.AFTER) {
                result = parent != null && parent.getActor() instanceof MutableActorHandler;
            } else if (position == DragAndDropTree.DropPosition.HERE) {
                result = parent != null && parent.getActor() instanceof MutableActorHandler;
            }
        }
        return result;
    }

    protected void highlightVariables(Node parent, String nameRegExp) {
        parent.findVariable(nameRegExp);
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Node child = (Node)parent.getChildAt(i);
            child.findVariable(nameRegExp);
            this.highlightVariables(child, nameRegExp);
        }
    }

    public void highlightVariables(String nameRegExp) {
        this.highlightVariables((Node)this.getModel().getRoot(), nameRegExp);
        ((Node)this.getModel().getRoot()).invalidateRendering();
        this.treeDidChange();
    }

    protected void enableBreakpoints(Node parent, boolean enable) {
        if (parent.getActor() instanceof Breakpoint) {
            parent.getActor().setSkip(!enable);
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            this.enableBreakpoints((Node)parent.getChildAt(i), enable);
        }
    }

    public void enableBreakpoints(boolean enable) {
        this.enableBreakpoints((Node)this.getModel().getRoot(), enable);
        this.treeDidChange();
    }

    public boolean restoreExpandedNodes(List<TreePath> expanded) {
        if (expanded == null) {
            return false;
        }
        ArrayList<TreePath> exp = new ArrayList<TreePath>();
        for (TreePath path : expanded) {
            String full = TreeHelper.pathToNode(path).getFullName();
            Node node = this.locate(full);
            if (node == null) continue;
            exp.add(new TreePath(node.getPath()));
        }
        this.setExpandedNodes(exp);
        return true;
    }

    public boolean processActor(TreePath path) {
        return this.processActor(path, null);
    }

    public boolean processActor(TreePath path, AbstractActorProcessor processor) {
        BaseDialog dialog;
        GraphicalOutputProducingProcessor graphical;
        ErrorMessagePanel errorPanel;
        ModifyingProcessor modifying;
        Node node;
        AbstractActor selected;
        AbstractActor flow = this.getActor();
        if (path != null && path.getPathCount() == 1) {
            path = null;
        }
        if (path == null) {
            selected = flow;
            node = (Node)this.getModel().getRoot();
        } else {
            selected = ActorUtils.locate(TreeHelper.treePathToActorPath(path).getChildPath(), flow);
            node = TreeHelper.pathToNode(path);
        }
        if (processor == null) {
            if (this.m_DialogProcessActors == null) {
                this.m_DialogProcessActors = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog()) : new GenericObjectEditorDialog(this.getParentFrame());
                this.m_DialogProcessActors.setTitle("Process actors");
                this.m_DialogProcessActors.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
                this.m_DialogProcessActors.getGOEEditor().setCanChangeClassInDialog(true);
                this.m_DialogProcessActors.getGOEEditor().setClassType(AbstractActorProcessor.class);
                this.m_DialogProcessActors.setCurrent(new RemoveDisabledActors());
            }
            this.m_DialogProcessActors.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            this.m_DialogProcessActors.setVisible(true);
            if (this.m_DialogProcessActors.getResult() != 0) {
                return false;
            }
            processor = (AbstractActorProcessor)this.m_DialogProcessActors.getCurrent();
        }
        if (processor instanceof ModifyingProcessor) {
            ((ModifyingProcessor)((Object)processor)).setNoCopy(true);
        }
        processor.process(selected);
        if (processor instanceof ModifyingProcessor && (modifying = (ModifyingProcessor)((Object)processor)).isModified()) {
            Node newNode;
            this.addUndoPoint("Processing actors with " + processor.toString());
            List<TreePath> exp = this.getExpandedNodes();
            if (path == null) {
                this.buildTree(modifying.getModifiedActor());
                newNode = node;
            } else {
                newNode = this.buildTree((Node)node.getParent(), modifying.getModifiedActor(), false);
                Node parent = (Node)node.getParent();
                int index = parent.getIndex(node);
                parent.remove(index);
                parent.insert(newNode, index);
            }
            this.setModified(true);
            this.nodeStructureChanged(newNode);
            this.restoreExpandedNodes(exp);
            this.notifyActorChangeListeners(new ActorChangeEvent(this, newNode, ActorChangeEvent.Type.MODIFY));
        }
        if (processor.hasErrors()) {
            errorPanel = new ErrorMessagePanel();
            errorPanel.setErrorMessage(Utils.flatten(processor.getErrors(), "\n"));
        } else {
            errorPanel = null;
        }
        if (processor instanceof GraphicalOutputProducingProcessor && (graphical = (GraphicalOutputProducingProcessor)((Object)processor)).hasGraphicalOutput()) {
            dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle(processor.getClass().getSimpleName());
            dialog.getContentPane().setLayout(new BorderLayout());
            final Component comp = graphical.getGraphicalOutput();
            if (errorPanel == null) {
                dialog.getContentPane().add(comp, "Center");
                if (comp instanceof MenuBarProvider) {
                    dialog.setJMenuBar(((MenuBarProvider)((Object)comp)).getMenuBar());
                }
            } else {
                final BaseDialog fDialog = dialog;
                final ErrorMessagePanel fErrorPanel = errorPanel;
                final BaseTabbedPane tabbedPane = new BaseTabbedPane();
                tabbedPane.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        if (tabbedPane.getSelectedIndex() == 0) {
                            if (comp instanceof MenuBarProvider) {
                                fDialog.setJMenuBar(((MenuBarProvider)((Object)comp)).getMenuBar());
                            } else {
                                fDialog.setJMenuBar(null);
                            }
                        } else {
                            fDialog.setJMenuBar(fErrorPanel.getMenuBar());
                        }
                    }
                });
                dialog.getContentPane().add((Component)tabbedPane, "Center");
                tabbedPane.addTab("Output", comp);
                tabbedPane.addTab("Errors", errorPanel);
            }
            if (comp instanceof MenuBarProvider) {
                dialog.setJMenuBar(((MenuBarProvider)((Object)comp)).getMenuBar());
            }
            dialog.pack();
            dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            dialog.setVisible(true);
            errorPanel = null;
        }
        if (errorPanel != null) {
            dialog = this.getParentDialog() != null ? new BaseDialog(this.getParentDialog()) : new BaseDialog(this.getParentFrame());
            dialog.setTitle(processor.getClass().getSimpleName());
            dialog.getContentPane().setLayout(new BorderLayout());
            dialog.getContentPane().add((Component)errorPanel, "Center");
            dialog.setJMenuBar(errorPanel.getMenuBar());
            dialog.pack();
            dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
            dialog.setVisible(true);
        }
        return true;
    }

    @Override
    public void setEditable(boolean value) {
        super.setEditable(value);
        if (this.getParent() != null) {
            this.getParent().invalidate();
            this.getParent().repaint();
        }
    }

    public Node getCurrentEditingNode() {
        return this.m_CurrentEditingNode;
    }

    public Node getCurrentEditingParent() {
        return this.m_CurrentEditingParent;
    }

    public void updateCurrentEditing(Node parent, Node node) {
        this.m_CurrentEditingParent = parent;
        this.m_CurrentEditingNode = node;
    }

    @Override
    protected DragAndDropTreeNodeCollection newNodeCollection(BaseTreeNode[] nodes) {
        Node[] nnodes = new Node[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            nnodes[i] = (Node)nodes[i];
        }
        return new TreeNodeCollection(nnodes);
    }

    @Override
    protected BaseTreeNode[] newTreeNodes(Transferable data) {
        TreeNodeCollection coll = TreeNodeCollection.fromTransferable(this, data);
        if (coll == null) {
            return new BaseTreeNode[0];
        }
        return coll.toArray((N[])new Node[coll.size()]);
    }

    public void refreshTabs() {
        if (this.getEditor() != null) {
            this.getEditor().refreshTabs();
        }
    }

    public void updateLastTemplate(AbstractActorTemplate template, InsertPosition position) {
        this.m_LastTemplate = template;
        this.m_LastTemplateInsertPosition = position;
    }

    public static enum InsertPosition {
        BENEATH,
        HERE,
        AFTER;

    }
}

