/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorPath;
import adams.gui.flow.tree.Node;
import javax.swing.tree.TreePath;

public class TreeHelper {
    public static Node pathToNode(TreePath path) {
        if (path == null) {
            return null;
        }
        return (Node)path.getLastPathComponent();
    }

    public static Node[] pathsToNodes(TreePath[] paths) {
        if (paths == null) {
            return null;
        }
        Node[] result = new Node[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = (Node)paths[i].getLastPathComponent();
        }
        return result;
    }

    public static AbstractActor pathToActor(TreePath path) {
        return TreeHelper.pathToActor(path, false);
    }

    public static AbstractActor pathToActor(TreePath path, boolean full) {
        if (path == null) {
            return null;
        }
        Node node = TreeHelper.pathToNode(path);
        AbstractActor result = full ? node.getFullActor() : node.getActor();
        return result;
    }

    public static AbstractActor[] pathsToActors(TreePath[] paths) {
        return TreeHelper.pathsToActors(paths, false);
    }

    public static AbstractActor[] pathsToActors(TreePath[] paths, boolean full) {
        if (paths == null) {
            return null;
        }
        AbstractActor[] result = new AbstractActor[paths.length];
        Node[] nodes = TreeHelper.pathsToNodes(paths);
        for (int i = 0; i < nodes.length; ++i) {
            result[i] = full ? nodes[i].getFullActor() : nodes[i].getActor();
        }
        return result;
    }

    public static ActorPath treePathToActorPath(TreePath path) {
        Object[] parts = path.getPath();
        String[] names = new String[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            names[i] = ((Node)parts[i]).getActor().getName();
        }
        return new ActorPath(names);
    }
}

