/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.menu;

import adams.core.Utils;
import adams.core.io.FlowFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.ExternalSink;
import adams.flow.source.ExternalSource;
import adams.flow.standalone.ExternalStandalone;
import adams.flow.transformer.ExternalTransformer;
import adams.gui.core.GUIHelper;
import adams.gui.event.ActorChangeEvent;
import adams.gui.flow.FlowEditorDialog;
import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.StateContainer;
import adams.gui.flow.tree.TreeHelper;
import adams.gui.flow.tree.menu.AbstractTreePopupMenuItemAction;
import java.awt.event.ActionEvent;
import javax.swing.tree.TreePath;

public class ExternalizeActor
extends AbstractTreePopupMenuItemAction {
    private static final long serialVersionUID = 3991575839421394939L;

    @Override
    protected String getTitle() {
        return "Externalize...";
    }

    @Override
    protected void doUpdate() {
        this.setEnabled(((StateContainer)this.m_State).editable && ((StateContainer)this.m_State).numSel >= 1 && ((StateContainer)this.m_State).tree.getOwner() != null);
    }

    protected void externalizeActor(TreePath[] paths) {
        AbstractActor handler;
        Node currNode;
        int i;
        if (paths.length == 0) {
            return;
        }
        if (paths.length == 1) {
            this.externalizeActor(paths[0]);
            return;
        }
        AbstractActor[] actors = new AbstractActor[paths.length];
        Node parent = null;
        for (i = 0; i < paths.length; ++i) {
            currNode = TreeHelper.pathToNode(paths[i]);
            actors[i] = currNode.getFullActor().shallowCopy();
            if (parent != null) continue;
            parent = (Node)currNode.getParent();
        }
        try {
            handler = (AbstractActor)ActorUtils.createExternalActor(actors);
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage(((StateContainer)this.m_State).tree, "Failed to externalize actor(s):\n" + Utils.throwableToString(e));
            return;
        }
        this.addUndoPoint("Enclosing " + paths.length + " nodes in " + handler.getClass().getName());
        Node newNode = ((StateContainer)this.m_State).tree.buildTree(null, handler, false);
        for (i = 0; i < paths.length; ++i) {
            currNode = TreeHelper.pathToNode(paths[i]);
            int index = parent.getIndex(currNode);
            parent.remove(index);
            if (i != 0) continue;
            parent.insert(newNode, index);
        }
        ((StateContainer)this.m_State).tree.updateActorName(newNode);
        ((StateContainer)this.m_State).tree.setModified(true);
        if (paths.length == 1) {
            ((StateContainer)this.m_State).tree.nodeStructureChanged(newNode);
            ((StateContainer)this.m_State).tree.locateAndDisplay(newNode.getFullName());
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, newNode, ActorChangeEvent.Type.MODIFY));
        } else {
            ((StateContainer)this.m_State).tree.nodeStructureChanged(parent);
            ((StateContainer)this.m_State).tree.locateAndDisplay(parent.getFullName());
            ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, parent, ActorChangeEvent.Type.MODIFY));
        }
        this.externalizeActor(new TreePath(newNode.getPath()));
    }

    protected void externalizeActor(TreePath path) {
        Node currNode = TreeHelper.pathToNode(path);
        AbstractActor currActor = currNode.getFullActor().shallowCopy();
        FlowEditorDialog dialog = this.getParentDialog() != null ? new FlowEditorDialog(this.getParentDialog()) : new FlowEditorDialog(this.getParentFrame());
        dialog.getFlowEditorPanel().newTab();
        dialog.getFlowEditorPanel().setCurrentFlow(currActor);
        dialog.getFlowEditorPanel().setModified(true);
        dialog.setVisible(true);
        if (dialog.getFlowEditorPanel().getCurrentFile() == null) {
            return;
        }
        this.addUndoPoint("Externalizing node '" + currNode.getFullName() + "'");
        AbstractExternalActor extActor = null;
        if (ActorUtils.isStandalone(currActor)) {
            extActor = new ExternalStandalone();
        } else if (ActorUtils.isSource(currActor)) {
            extActor = new ExternalSource();
        } else if (ActorUtils.isTransformer(currActor)) {
            extActor = new ExternalTransformer();
        } else if (ActorUtils.isSink(currActor)) {
            extActor = new ExternalSink();
        }
        extActor.setActorFile(new FlowFile(dialog.getFlowEditorPanel().getCurrentFile()));
        ((StateContainer)this.m_State).tree.setModified(true);
        currNode.setActor(extActor);
        currNode.removeAllChildren();
        ((StateContainer)this.m_State).tree.nodeStructureChanged(currNode);
        ((StateContainer)this.m_State).tree.notifyActorChangeListeners(new ActorChangeEvent(((StateContainer)this.m_State).tree, currNode, ActorChangeEvent.Type.MODIFY));
    }

    @Override
    protected void doActionPerformed(ActionEvent e) {
        this.externalizeActor(((StateContainer)this.m_State).selPaths);
    }
}

