/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.print;

import adams.core.io.PlaceholderFile;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.ImagePreview;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileFilter;
import adams.gui.print.PNGWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class JComponentWriterFileChooser
extends BaseFileChooser {
    private static final long serialVersionUID = -7671035763970202570L;
    public static final int UNHANDLED_DIALOG = 0;
    public static final int WRITER_DIALOG = 2;
    protected static List<JComponentWriterFileFilter> m_WriterFileFilters;
    protected int m_DialogType;
    protected Object m_CurrentConverter;
    protected PropertyChangeListener m_Listener;
    protected FileFilter m_LastFilter;
    protected JComponentWriter m_PreferredWriter;
    protected JCheckBox m_CheckBoxOptions;
    protected ImagePreview m_ImagePreview;
    protected GenericObjectEditor m_Editor;

    public JComponentWriterFileChooser() {
        this.initialize();
    }

    public JComponentWriterFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    public JComponentWriterFileChooser(String currentDirectory) {
        super(currentDirectory);
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        JComponentWriterFileChooser.initFilters();
        super.setAcceptAllFileFilterUsed(false);
        this.setAutoAppendExtension(true);
        this.setPromptOverwriteFile(true);
        this.m_PreferredWriter = JComponentWriter.forCommandLine(GUIHelper.getString("PreferredJComponentWriter", new PNGWriter().toCommandLine()));
        this.m_Editor = new GenericObjectEditor(false);
    }

    @Override
    protected JComponent createAccessoryPanel() {
        super.createAccessoryPanel();
        this.m_CheckBoxOptions = new JCheckBox("Edit options");
        this.m_CheckBoxOptions.setMnemonic('E');
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)this.m_CheckBoxOptions, "North");
        JPanel panel = new JPanel(new BorderLayout());
        result.add((Component)panel, "Center");
        this.m_ImagePreview = new ImagePreview(this);
        panel.add((Component)((Object)this.m_PanelBookmarks), "Center");
        panel.add((Component)this.m_ImagePreview, "South");
        Dimension dim = this.getDefaultAccessoryDimension();
        if (dim != null) {
            result.setSize(dim);
            result.setMinimumSize(dim);
            result.setPreferredSize(dim);
        }
        return result;
    }

    protected static synchronized void initFilters() {
        if (m_WriterFileFilters == null) {
            JComponentWriterFileFilter[] list = JComponentWriter.getFileFilters();
            m_WriterFileFilters = new ArrayList<JComponentWriterFileFilter>();
            for (int i = 0; i < list.length; ++i) {
                m_WriterFileFilters.add(list[i]);
            }
        }
    }

    protected void initGUI(int dialogType) {
        this.resetChoosableFileFilters();
        List<JComponentWriterFileFilter> list = m_WriterFileFilters;
        JComponentWriterFileFilter preferred = null;
        for (int i = 0; i < list.size(); ++i) {
            this.addChoosableFileFilter(list.get(i));
            if (this.m_PreferredWriter == null || !list.get(i).getWriter().getClass().equals(this.m_PreferredWriter.getClass())) continue;
            preferred = list.get(i);
        }
        if (list.size() > 0) {
            FileFilter active = list.get(0);
            if (preferred != null) {
                active = preferred;
            }
            if (this.m_LastFilter != null) {
                active = this.m_LastFilter;
            }
            this.setFileFilter(active);
        }
        if (this.m_Listener != null) {
            this.removePropertyChangeListener(this.m_Listener);
        }
        this.m_Listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("fileFilterChanged")) {
                    JComponentWriterFileChooser.this.updateCurrentConverter();
                }
            }
        };
        this.addPropertyChangeListener(this.m_Listener);
        if (dialogType == 2) {
            this.m_Editor.setClassType(JComponentWriter.class);
            this.m_Editor.setValue(list.get(0).getWriter());
        }
        this.updateCurrentConverter();
    }

    @Override
    public int showDialog(Component parent, String approveButtonText) {
        if (this.m_DialogType == 0) {
            throw new IllegalStateException("Either use showOpenDialog or showSaveDialog!");
        }
        return super.showDialog(parent, approveButtonText);
    }

    @Override
    public int showOpenDialog(Component parent) {
        throw new IllegalStateException("Cannot load images!");
    }

    @Override
    public int showSaveDialog(Component parent) {
        String[] extensions;
        String filename;
        this.m_DialogType = 2;
        this.m_CurrentConverter = null;
        this.initGUI(2);
        FileFilter currentFilter = this.getFileFilter();
        File currentFile = this.getSelectedFile();
        this.setAcceptAllFileFilterUsed(false);
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        int result = super.showSaveDialog(parent);
        if (result == 0 && this.getFileFilter() instanceof JComponentWriterFileFilter && !(filename = this.getSelectedFile().getAbsolutePath()).endsWith((extensions = ((JComponentWriterFileFilter)this.getFileFilter()).getExtensions())[0])) {
            filename = filename + extensions[0];
            this.setSelectedFile(new File(filename));
        }
        currentFilter = this.getFileFilter();
        currentFile = this.getSelectedFile();
        this.setFileFilter(currentFilter);
        this.setSelectedFile(currentFile);
        this.m_DialogType = 0;
        this.removePropertyChangeListener(this.m_Listener);
        if (result == 0) {
            this.m_LastFilter = this.getFileFilter();
            this.configureCurrentConverter(2);
            if (this.m_CheckBoxOptions.isSelected()) {
                this.m_Editor.setValue(this.m_CurrentConverter);
                GenericObjectEditorDialog dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
                dialog.setLocationRelativeTo(GUIHelper.getParentComponent(this));
                dialog.setVisible(true);
                result = dialog.getResultType();
                if (result == 0) {
                    this.m_CurrentConverter = this.m_Editor.getValue();
                }
            }
        }
        return result;
    }

    public JComponentWriter getWriter() {
        this.configureCurrentConverter(2);
        return (JComponentWriter)this.m_CurrentConverter;
    }

    protected void updateCurrentConverter() {
        if (this.getFileFilter() == null) {
            return;
        }
        try {
            JComponentWriter newConverter = ((JComponentWriterFileFilter)this.getFileFilter()).getWriter();
            if (this.m_CurrentConverter == null) {
                this.m_CurrentConverter = newConverter;
            } else if (!this.m_CurrentConverter.getClass().equals(newConverter.getClass())) {
                this.m_CurrentConverter = newConverter;
            }
        }
        catch (Exception e) {
            this.m_CurrentConverter = null;
            e.printStackTrace();
        }
    }

    protected void configureCurrentConverter(int dialogType) {
        if (this.getSelectedPlaceholderFile() == null) {
            return;
        }
        PlaceholderFile selFile = this.getSelectedPlaceholderFile();
        if (this.m_CurrentConverter == null) {
            this.m_CurrentConverter = ((JComponentWriterFileFilter)this.getFileFilter()).getWriter();
            if (this.m_CurrentConverter == null) {
                return;
            }
        }
        try {
            PlaceholderFile currFile = ((JComponentWriter)this.m_CurrentConverter).getFile();
            if (currFile == null || !((File)currFile).getAbsolutePath().equals(selFile.getAbsolutePath())) {
                ((JComponentWriter)this.m_CurrentConverter).setFile(selFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean b) {
        super.setAcceptAllFileFilterUsed(false);
    }
}

