/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.gui.core.ClearableModel;
import adams.gui.core.CustomSearchTableModel;
import adams.gui.core.SearchParameters;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public abstract class AbstractManagementTableModel<T extends Comparable>
extends AbstractTableBasedSelectionPanel.AbstractSelectionTableModel<T>
implements ClearableModel,
CustomSearchTableModel {
    private static final long serialVersionUID = 7481209191067222765L;
    protected List<T> m_Values;
    protected boolean m_Sorted;

    public AbstractManagementTableModel() {
        this(false);
    }

    public AbstractManagementTableModel(boolean sorted) {
        this(new ArrayList(), sorted);
    }

    public AbstractManagementTableModel(T[] values) {
        this((Comparable[])values, true);
    }

    public AbstractManagementTableModel(T[] values, boolean sorted) {
        this(new ArrayList<T>(Arrays.asList(values)), sorted);
    }

    public AbstractManagementTableModel(List<T> values) {
        this(values, true);
    }

    public AbstractManagementTableModel(List<T> values, boolean sorted) {
        this.m_Values = new ArrayList<T>(values);
        this.m_Sorted = sorted;
        if (this.m_Sorted) {
            Collections.sort(this.m_Values);
        }
    }

    public boolean isSorted() {
        return this.m_Sorted;
    }

    @Override
    public int getRowCount() {
        return this.m_Values.size();
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract String getColumnName(int var1);

    public abstract Class getColumnClass(int var1);

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    public T getItemAt(int row) {
        if (row >= 0 && row < this.m_Values.size()) {
            return (T)((Comparable)this.m_Values.get(row));
        }
        return null;
    }

    @Override
    public int indexOf(T value) {
        int result = -1;
        if (value != null) {
            for (int i = 0; i < this.m_Values.size(); ++i) {
                if (!value.equals(this.m_Values.get(i))) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    @Override
    public abstract boolean isSearchMatch(SearchParameters var1, int var2);

    @Override
    public void clear() {
        this.m_Values = new Vector<T>();
        this.fireTableDataChanged();
    }

    public void add(T value) {
        if (this.m_Values.contains(value)) {
            return;
        }
        this.m_Values.add(value);
        if (this.m_Sorted) {
            Collections.sort(this.m_Values);
        }
        this.fireTableDataChanged();
    }

    public void addAll(List<T> values) {
        boolean modified = false;
        for (Comparable value : values) {
            if (this.m_Values.contains(value)) continue;
            modified = true;
            this.m_Values.add(value);
        }
        if (!modified) {
            return;
        }
        if (this.m_Sorted) {
            Collections.sort(this.m_Values);
        }
        this.fireTableDataChanged();
    }

    public void remove(T value) {
        if (!this.m_Values.contains(value)) {
            return;
        }
        this.m_Values.remove(value);
        this.fireTableDataChanged();
    }

    public boolean moveUp(int index) {
        boolean result = false;
        if (index > 0 && index < this.m_Values.size()) {
            Comparable backup = (Comparable)this.m_Values.get(index);
            this.m_Values.remove(index);
            this.m_Values.add(index - 1, backup);
            result = true;
        }
        this.fireTableDataChanged();
        return result;
    }

    public boolean moveDown(int index) {
        boolean result = false;
        if (index >= 0 && index < this.m_Values.size() - 1) {
            Comparable backup = (Comparable)this.m_Values.get(index);
            this.m_Values.remove(index);
            this.m_Values.add(index + 1, backup);
            result = true;
        }
        this.fireTableDataChanged();
        return result;
    }

    public List<T> toList() {
        return new ArrayList<T>(this.m_Values);
    }
}

