/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.gui.core.SearchPanel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerList;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.SearchableContainerManager;
import java.awt.Component;
import java.awt.Dimension;

public abstract class AbstractSearchableContainerList<M extends AbstractContainerManager, C extends AbstractContainer>
extends AbstractContainerList<M, C> {
    private static final long serialVersionUID = -5812608011245974771L;
    protected SearchPanel m_PanelSearch;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false, "Search", true, "");
        this.m_PanelSearch.setTextColumns(10);
        this.m_PanelSearch.setVisible(false);
        this.m_PanelSearch.addSearchListener(new SearchListener(){

            @Override
            public void searchInitiated(SearchEvent e) {
                if (!AbstractSearchableContainerList.this.getAllowSearch()) {
                    return;
                }
                SearchableContainerManager smanager = (SearchableContainerManager)AbstractSearchableContainerList.this.getManager();
                if (e.getParameters().getSearchString() == null) {
                    smanager.clearSearch();
                } else {
                    smanager.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                }
            }
        });
        this.add((Component)this.m_PanelSearch, "South");
    }

    @Override
    public void setAllowSearch(boolean value) {
        if (this.getManager() instanceof SearchableContainerManager) {
            this.m_PanelSearch.setVisible(value);
        } else {
            this.m_PanelSearch.setVisible(false);
        }
    }

    @Override
    public boolean getAllowSearch() {
        return this.m_PanelSearch.isVisible();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = (Dimension)super.getPreferredSize().clone();
        if (result.width < this.m_PanelSearch.getPreferredSize().width) {
            result.width = this.m_PanelSearch.getPreferredSize().width;
        }
        return result;
    }
}

