/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core.axis;

import adams.core.ClassLister;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.gui.visualization.core.axis.AbstractAxisModel;
import adams.gui.visualization.core.axis.Tick;
import adams.gui.visualization.core.axis.TickGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractTickGenerator
extends AbstractOptionHandler
implements TickGenerator {
    private static final long serialVersionUID = -3950212023344727427L;
    protected AbstractAxisModel m_Parent;
    protected List<Tick> m_Ticks;
    protected HashSet<String> m_Labels;

    @Override
    protected void reset() {
        super.reset();
        if (this.m_Parent != null) {
            this.m_Parent.update();
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Parent = null;
        this.m_Labels = new HashSet();
        this.m_Ticks = new ArrayList<Tick>();
    }

    @Override
    public void setParent(AbstractAxisModel value) {
        this.m_Parent = value;
    }

    @Override
    public AbstractAxisModel getParent() {
        return this.m_Parent;
    }

    protected boolean hasLabel(String label) {
        boolean result = false;
        if (label != null && this.m_Labels.contains(label)) {
            result = true;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("hasTick: '" + label + "' -> " + result);
        }
        return result;
    }

    protected String fixLabel(String label) {
        if (label == null) {
            return null;
        }
        if (label.equals("NaN")) {
            return null;
        }
        if (this.hasLabel(label)) {
            return null;
        }
        return label;
    }

    protected void addLabel(String label) {
        if (label != null) {
            this.m_Labels.add(label);
        }
    }

    protected void preGenerate() {
        this.m_Labels.clear();
    }

    protected abstract void doGenerate();

    protected void postGenerate() {
        this.m_Labels.clear();
    }

    @Override
    public List<Tick> getTicks() {
        this.m_Ticks.clear();
        if (this.m_Parent == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("no parent set, no ticks");
            }
            return this.m_Ticks;
        }
        this.preGenerate();
        this.doGenerate();
        this.postGenerate();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("ticks: " + this.m_Ticks);
        }
        return this.m_Ticks;
    }

    @Override
    public TickGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public TickGenerator shallowCopy(boolean expand) {
        return (TickGenerator)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getGenerators() {
        return ClassLister.getSingleton().getClassnames(TickGenerator.class);
    }

    public static TickGenerator forName(String classname, String[] options) {
        TickGenerator result;
        try {
            result = (TickGenerator)OptionUtils.forName(TickGenerator.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static TickGenerator forCommandLine(String cmdline) {
        return (TickGenerator)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }
}

