/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.propertyextractor;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.gui.visualization.debug.propertyextractor.DefaultPropertyExtractor;
import java.util.Hashtable;

public abstract class AbstractPropertyExtractor
implements CleanUpHandler {
    protected static Hashtable<Class, Class> m_Cache = new Hashtable();
    protected static String[] m_Extractors = null;
    protected static Class[] m_ExtractorClasses = null;
    protected Object m_Current;

    protected static synchronized void initExtractors() {
        if (m_Extractors != null) {
            return;
        }
        m_Extractors = ClassLister.getSingleton().getClassnames(AbstractPropertyExtractor.class);
        m_ExtractorClasses = new Class[m_Extractors.length];
        for (int i = 0; i < m_Extractors.length; ++i) {
            try {
                AbstractPropertyExtractor.m_ExtractorClasses[i] = Class.forName(m_Extractors[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate inspection extractor '" + m_Extractors[i] + "': ");
                e.printStackTrace();
            }
        }
    }

    public static synchronized AbstractPropertyExtractor getExtractor(Object obj) {
        return AbstractPropertyExtractor.getExtractor(obj.getClass());
    }

    public static synchronized AbstractPropertyExtractor getExtractor(Class cls) {
        AbstractPropertyExtractor result = null;
        AbstractPropertyExtractor.initExtractors();
        if (m_Cache.containsKey(cls)) {
            try {
                result = (AbstractPropertyExtractor)m_Cache.get(cls).newInstance();
                return result;
            }
            catch (Exception e) {
                result = null;
            }
        }
        for (int i = 0; i < m_ExtractorClasses.length; ++i) {
            if (m_ExtractorClasses[i] == DefaultPropertyExtractor.class) continue;
            try {
                AbstractPropertyExtractor extractor = (AbstractPropertyExtractor)m_ExtractorClasses[i].newInstance();
                if (!extractor.handles(cls)) continue;
                result = extractor;
                break;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new DefaultPropertyExtractor();
        }
        m_Cache.put(cls, result.getClass());
        return result;
    }

    public abstract boolean handles(Class var1);

    public void setCurrent(Object value) {
        this.m_Current = value;
        this.initialize();
    }

    public Object getCurrent() {
        return this.m_Current;
    }

    protected void initialize() {
    }

    public abstract int size();

    public boolean hasValue(int index) {
        return this.getValue(index) != null;
    }

    public abstract Object getValue(int var1);

    public abstract String getLabel(int var1);

    @Override
    public void cleanUp() {
        this.m_Current = null;
    }
}

