/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.gui.core.BasePanel;
import adams.gui.core.ColorHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.ParameterPanel;
import adams.gui.visualization.image.ImagePanel;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JTextField;

public class ColorPickerPanel
extends BasePanel {
    private static final long serialVersionUID = 2681238147953193199L;
    protected ImagePanel m_Owner;
    protected MouseAdapter m_MouseListener;
    protected MouseMotionAdapter m_MouseMotionListener;
    protected ZoomPanel m_PanelZoom;
    protected ParameterPanel m_PanelColors;
    protected JTextField m_TextSelectedColor;
    protected JTextField m_TextCurrentColor;

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelZoom = new ZoomPanel(this);
        this.add((Component)this.m_PanelZoom, "Center");
        this.m_PanelColors = new ParameterPanel();
        this.add((Component)this.m_PanelColors, "East");
        this.m_TextCurrentColor = new JTextField(10);
        this.m_TextCurrentColor.setEditable(false);
        this.m_PanelColors.addParameter("Current", this.m_TextCurrentColor);
        this.m_TextSelectedColor = new JTextField(10);
        this.m_TextSelectedColor.setEditable(false);
        this.m_PanelColors.addParameter("Selected", this.m_TextSelectedColor);
    }

    public void setOwner(ImagePanel value) {
        this.m_Owner = value;
    }

    public ImagePanel getOwner() {
        return this.m_Owner;
    }

    public static Color getContrastColor(Color color) {
        double y = (299 * color.getRed() + 587 * color.getGreen() + 114 * color.getBlue()) / 1000;
        return y >= 128.0 ? Color.black : Color.white;
    }

    protected void updateColor(JTextField field, Color color) {
        field.setText(ColorHelper.toHex(color));
        field.setBackground(color);
        field.setForeground(ColorHelper.getContrastColor(color));
    }

    protected Color getColorAt(Point p) {
        int x = (int)(p.getX() / this.m_Owner.getPaintPanel().getScale());
        int y = (int)(p.getY() / this.m_Owner.getPaintPanel().getScale());
        int pixel = this.m_Owner.getPaintPanel().getCurrentImage().getRGB(x, y);
        return new Color(pixel);
    }

    public void start() {
        this.m_MouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isLeftClick(e)) {
                    ColorPickerPanel.this.updateColor(ColorPickerPanel.this.m_TextSelectedColor, ColorPickerPanel.this.getColorAt(e.getPoint()));
                    e.consume();
                } else {
                    super.mouseClicked(e);
                }
            }
        };
        this.m_MouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ColorPickerPanel.this.m_PanelZoom.setFocus(e.getPoint());
                ColorPickerPanel.this.updateColor(ColorPickerPanel.this.m_TextCurrentColor, ColorPickerPanel.this.getColorAt(e.getPoint()));
            }
        };
        this.m_Owner.getPaintPanel().addMouseListener(this.m_MouseListener);
        this.m_Owner.getPaintPanel().addMouseMotionListener(this.m_MouseMotionListener);
        this.m_Owner.getPaintPanel().setCursor(Cursor.getPredefinedCursor(1));
    }

    public void stop() {
        this.m_Owner.getPaintPanel().setCursor(Cursor.getDefaultCursor());
        this.m_Owner.getPaintPanel().removeMouseListener(this.m_MouseListener);
        this.m_Owner.getPaintPanel().removeMouseMotionListener(this.m_MouseMotionListener);
    }

    public void setSelectedColor(Color value) {
        this.m_TextSelectedColor.setText(ColorHelper.toHex(value));
    }

    public Color getSelectedColor() {
        return ColorHelper.valueOf(this.m_TextSelectedColor.getText());
    }

    public static class ZoomPanel
    extends BasePanel {
        private static final long serialVersionUID = -3851710755212789298L;
        protected ColorPickerPanel m_Owner;
        protected Point m_Focus;
        protected double m_Scale;
        protected int m_FocusSize;

        public ZoomPanel(ColorPickerPanel owner) {
            this.m_Owner = owner;
            this.m_Focus = new Point(0, 0);
            this.m_Scale = 16.0;
            this.m_FocusSize = 7;
            this.updatePreferredSize();
        }

        public void setFocus(Point value) {
            this.m_Focus = value;
            this.repaint();
        }

        public Point getFocus() {
            return this.m_Focus;
        }

        public void setScale(double value) {
            this.m_Scale = value;
            this.updatePreferredSize();
            this.repaint();
        }

        public double getScale() {
            return this.m_Scale;
        }

        public void setFocusSize(int value) {
            this.m_FocusSize = value;
            this.updatePreferredSize();
            this.repaint();
        }

        public int getFocusSize() {
            return this.m_FocusSize;
        }

        protected void updatePreferredSize() {
            this.setPreferredSize(new Dimension((int)((double)this.m_FocusSize * this.m_Scale), (int)((double)this.m_FocusSize * this.m_Scale)));
        }

        protected BufferedImage createSubImage() {
            BufferedImage result = null;
            if (this.m_Owner.getOwner().getPaintPanel().getCurrentImage() != null) {
                BufferedImage img = this.m_Owner.getOwner().getPaintPanel().getCurrentImage();
                double scale = this.m_Owner.getOwner().getPaintPanel().getScale();
                int x = (int)(this.m_Focus.getX() / scale - (double)(this.m_FocusSize / 2));
                if (x < 0) {
                    x = 0;
                } else if (x >= img.getWidth()) {
                    x = img.getWidth() - this.m_FocusSize;
                }
                int y = (int)(this.m_Focus.getY() / scale - (double)(this.m_FocusSize / 2));
                if (y < 0) {
                    y = 0;
                } else if (y >= img.getHeight()) {
                    y = img.getHeight() - this.m_FocusSize;
                }
                result = img.getSubimage(x, y, this.m_FocusSize, this.m_FocusSize);
            }
            return result;
        }

        protected int[] calcFocusPosition() {
            int[] result;
            if (this.m_Owner.getOwner().getPaintPanel().getCurrentImage() != null) {
                BufferedImage img = this.m_Owner.getOwner().getPaintPanel().getCurrentImage();
                int xCorr = this.m_FocusSize / 2;
                int yCorr = this.m_FocusSize / 2;
                double scale = this.m_Owner.getOwner().getPaintPanel().getScale();
                int x = (int)(this.m_Focus.getX() / scale - (double)(this.m_FocusSize / 2));
                if (x < 0) {
                    xCorr += x;
                } else if (x >= img.getWidth()) {
                    xCorr += x - img.getWidth();
                }
                int y = (int)(this.m_Focus.getY() / scale - (double)(this.m_FocusSize / 2));
                if (y < 0) {
                    yCorr += y;
                } else if (y >= img.getHeight()) {
                    yCorr += y - img.getHeight();
                }
                result = new int[]{xCorr, yCorr};
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public void paint(Graphics g) {
            BufferedImage img;
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.m_Owner != null && (img = this.createSubImage()) != null) {
                ((Graphics2D)g).scale(this.m_Scale, this.m_Scale);
                g.drawImage(img, 0, 0, this.m_Owner.getOwner().getBackgroundColor(), null);
                int[] pos = this.calcFocusPosition();
                g.setColor(Color.RED);
                Stroke stroke = ((Graphics2D)g).getStroke();
                ((Graphics2D)g).setStroke(new BasicStroke((float)(1.0 / this.m_Scale)));
                g.drawRect(pos[0], pos[1], 1, 1);
                ((Graphics2D)g).setStroke(stroke);
            }
        }
    }
}

